/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage.schedule;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.node.app.hapi.fees.usage.EstimatorFactory;
import com.hedera.node.app.hapi.fees.usage.QueryUsage;
import com.hedera.node.app.hapi.fees.usage.SigUsage;
import com.hedera.node.app.hapi.fees.usage.SingletonEstimatorUtils;
import com.hedera.node.app.hapi.fees.usage.SingletonUsageProperties;
import com.hedera.node.app.hapi.fees.usage.TxnUsageEstimator;
import com.hedera.node.app.hapi.fees.usage.schedule.ExtantScheduleContext;
import com.hedera.node.app.hapi.fees.usage.schedule.entities.ScheduleEntitySizes;
import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.Key;
import com.hederahashgraph.api.proto.java.Query;
import com.hederahashgraph.api.proto.java.ResponseType;
import com.hederahashgraph.api.proto.java.SchedulableTransactionBody;
import com.hederahashgraph.api.proto.java.ScheduleCreateTransactionBody;
import com.hederahashgraph.api.proto.java.ScheduleGetInfoQuery;
import com.hederahashgraph.api.proto.java.SubType;
import com.hederahashgraph.api.proto.java.TransactionBody;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ScheduleOpsUsage {
    private static final long SCHEDULED_TXN_ID_SIZE = 36L;
    @VisibleForTesting
    EstimatorFactory txnEstimateFactory = TxnUsageEstimator::new;
    @VisibleForTesting
    Function<ResponseType, QueryUsage> queryEstimateFactory = QueryUsage::new;

    @Inject
    public ScheduleOpsUsage() {
    }

    public FeeData scheduleInfoUsage(Query scheduleInfo, ExtantScheduleContext ctx) {
        ScheduleGetInfoQuery op = scheduleInfo.getScheduleGetInfo();
        QueryUsage estimate = this.queryEstimateFactory.apply(op.getHeader().getResponseType());
        estimate.addTb(24L);
        estimate.addRb(ctx.nonBaseRb());
        return estimate.get();
    }

    public FeeData scheduleCreateUsage(TransactionBody scheduleCreate, SigUsage sigUsage, long lifetimeSecs) {
        ScheduleCreateTransactionBody op = scheduleCreate.getScheduleCreate();
        SchedulableTransactionBody scheduledTxn = op.getScheduledTransactionBody();
        long msgBytesUsed = (long)scheduledTxn.getSerializedSize() + (long)op.getMemoBytes().size();
        if (op.hasPayerAccountID()) {
            msgBytesUsed += 24L;
        }
        ExtantScheduleContext.Builder creationCtx = ExtantScheduleContext.newBuilder().setScheduledTxn(scheduledTxn).setNumSigners(ScheduleEntitySizes.SCHEDULE_ENTITY_SIZES.estimatedScheduleSigs(sigUsage)).setMemo(op.getMemo()).setResolved(false);
        if (op.hasAdminKey()) {
            Key adminKey = op.getAdminKey();
            msgBytesUsed += (long)FeeBuilder.getAccountKeyStorageSize((Key)adminKey);
            creationCtx.setAdminKey(adminKey);
        } else {
            creationCtx.setNoAdminKey();
        }
        TxnUsageEstimator estimate = this.txnEstimateFactory.get(sigUsage, scheduleCreate, SingletonEstimatorUtils.ESTIMATOR_UTILS);
        estimate.addBpt(msgBytesUsed);
        estimate.addRbs(creationCtx.build().nonBaseRb() * lifetimeSecs);
        estimate.addNetworkRbs(60L * SingletonUsageProperties.USAGE_PROPERTIES.legacyReceiptStorageSecs());
        if (scheduledTxn.hasContractCall()) {
            return estimate.get(SubType.SCHEDULE_CREATE_CONTRACT_CALL);
        }
        return estimate.get();
    }

    public FeeData scheduleSignUsage(TransactionBody scheduleSign, SigUsage sigUsage, long scheduleExpiry) {
        TxnUsageEstimator estimate = this.txnEstimateFactory.get(sigUsage, scheduleSign, SingletonEstimatorUtils.ESTIMATOR_UTILS);
        estimate.addBpt(24L);
        int estNewSigners = ScheduleEntitySizes.SCHEDULE_ENTITY_SIZES.estimatedScheduleSigs(sigUsage);
        long lifetime = SingletonEstimatorUtils.ESTIMATOR_UTILS.relativeLifetime(scheduleSign, scheduleExpiry);
        estimate.addRbs((long)ScheduleEntitySizes.SCHEDULE_ENTITY_SIZES.bytesUsedForSigningKeys(estNewSigners) * lifetime);
        estimate.addNetworkRbs(36L * SingletonUsageProperties.USAGE_PROPERTIES.legacyReceiptStorageSecs());
        return estimate.get();
    }

    public FeeData scheduleDeleteUsage(TransactionBody scheduleDelete, SigUsage sigUsage, long scheduleExpiry) {
        TxnUsageEstimator estimate = this.txnEstimateFactory.get(sigUsage, scheduleDelete, SingletonEstimatorUtils.ESTIMATOR_UTILS);
        estimate.addBpt(24L);
        long lifetime = SingletonEstimatorUtils.ESTIMATOR_UTILS.relativeLifetime(scheduleDelete, scheduleExpiry);
        estimate.addRbs(12L * lifetime);
        return estimate.get();
    }
}

