/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.tokenkey;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.hapi.utils.InvalidTransactionException;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.HtsSystemContract;
import javax.inject.Singleton;

@Singleton
public class TokenKeyCommons {
    private TokenKeyCommons() {
    }

    public static Key getTokenKey(Token token, int keyType, ContractID systemContractId) throws InvalidTransactionException {
        if (token == null) {
            return null;
        }
        return switch (keyType) {
            case 1 -> token.adminKey();
            case 2 -> token.kycKey();
            case 4 -> token.freezeKey();
            case 8 -> token.wipeKey();
            case 16 -> token.supplyKey();
            case 32 -> token.feeScheduleKey();
            case 64 -> token.pauseKey();
            case 128 -> {
                if (systemContractId.equals((Object)HtsSystemContract.HTS_16C_CONTRACT_ID)) {
                    yield token.metadataKey();
                }
                yield null;
            }
            default -> null;
        };
    }
}

