/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.quiescence;

import com.hedera.node.app.quiescence.BadMetadataException;
import com.hedera.node.app.quiescence.QuiescenceController;
import com.hedera.node.app.quiescence.QuiescenceUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import org.hiero.base.CompareTo;
import org.hiero.consensus.model.transaction.Transaction;

public class QuiescenceBlockTracker {
    private final long blockNumber;
    private final QuiescenceController controller;
    private long relevantTransactionCount = 0L;
    private Instant maxConsensusTime = Instant.EPOCH;
    private boolean blockFinalized = false;

    QuiescenceBlockTracker(long blockNumber, @NonNull QuiescenceController controller) {
        this.blockNumber = blockNumber;
        this.controller = controller;
    }

    public void blockTransaction(@NonNull Transaction txn) {
        if (this.controller.isDisabled()) {
            return;
        }
        if (this.blockFinalized) {
            this.controller.disableQuiescence("Block already finalized but received more transactions");
            return;
        }
        try {
            if (QuiescenceUtils.isRelevantTransaction(txn)) {
                ++this.relevantTransactionCount;
            }
        }
        catch (BadMetadataException e) {
            this.controller.disableQuiescence(e);
        }
    }

    public void consensusTimeAdvanced(@NonNull Instant newConsensusTime) {
        if (this.controller.isDisabled()) {
            return;
        }
        if (this.blockFinalized) {
            this.controller.disableQuiescence("Block already finalized");
        }
        this.maxConsensusTime = (Instant)CompareTo.max((Comparable)this.maxConsensusTime, (Comparable)newConsensusTime);
    }

    public void finishedHandlingTransactions() {
        if (this.controller.isDisabled()) {
            return;
        }
        this.blockFinalized = true;
        this.controller.blockFinalized(this);
    }

    public long getBlockNumber() {
        return this.blockNumber;
    }

    public long getRelevantTransactionCount() {
        return this.relevantTransactionCount;
    }

    @NonNull
    public Instant getMaxConsensusTime() {
        return this.maxConsensusTime;
    }
}

