/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.signature.impl;

import com.hedera.hapi.node.base.Key;
import com.hedera.node.app.signature.SignatureVerificationFuture;
import com.hedera.node.app.signature.impl.SignatureVerificationImpl;
import com.hedera.node.app.spi.signatures.SignatureVerification;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hiero.base.crypto.TransactionSignature;
import org.hiero.base.crypto.VerificationStatus;

public final class SignatureVerificationFutureImpl
implements SignatureVerificationFuture {
    private final Key key;
    private final Bytes evmAlias;
    private final TransactionSignature txSig;
    private boolean canceled = false;

    public SignatureVerificationFutureImpl(@NonNull Key key, @Nullable Bytes evmAlias, @NonNull TransactionSignature txSig) {
        this.key = Objects.requireNonNull(key);
        this.evmAlias = evmAlias;
        this.txSig = Objects.requireNonNull(txSig);
    }

    @Override
    @Nullable
    public Bytes evmAlias() {
        return this.evmAlias;
    }

    @Override
    @NonNull
    public Key key() {
        return this.key;
    }

    @NonNull
    public TransactionSignature txSig() {
        return this.txSig;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        this.canceled = true;
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    @NonNull
    public SignatureVerification get() throws InterruptedException, ExecutionException {
        return new SignatureVerificationImpl(this.key, this.evmAlias, this.txSig.getSignatureStatus() == VerificationStatus.VALID);
    }

    @Override
    @NonNull
    public SignatureVerification get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return new SignatureVerificationImpl(this.key, this.evmAlias, this.txSig.getSignatureStatus() == VerificationStatus.VALID);
    }
}

