/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.code;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.code.CodeSection;
import org.hyperledger.besu.evm.code.EOFLayout;
import org.hyperledger.besu.evm.code.EOFValidator;
import org.hyperledger.besu.evm.code.OpcodeInfo;
import org.hyperledger.besu.evm.code.WorkList;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.RelativeJumpVectorOperation;

public class CodeV1Validation
implements EOFValidator {
    static final int MAX_STACK_HEIGHT = 1024;
    protected final int maxContainerSize;

    public CodeV1Validation(int maxContainerSize) {
        this.maxContainerSize = maxContainerSize;
    }

    @Override
    public String validate(EOFLayout layout) {
        if (layout.container().size() > this.maxContainerSize) {
            return "container_size_above_limit of " + this.maxContainerSize;
        }
        ArrayDeque<EOFLayout> workList = new ArrayDeque<EOFLayout>(layout.getSubcontainerCount());
        workList.add(layout);
        while (!workList.isEmpty()) {
            EOFLayout container = (EOFLayout)workList.poll();
            workList.addAll(List.of(container.subContainers()));
            if (container != layout && container.containerMode().get() == null) {
                return "orphan_subcontainer #" + layout.indexOfSubcontainer(container);
            }
            if (container.containerMode().get() != EOFLayout.EOFContainerMode.RUNTIME && container.data().size() != container.dataLength()) {
                return "Incomplete data section " + (String)(container == layout ? " at root" : " in container #" + layout.indexOfSubcontainer(container));
            }
            String codeValidationError = this.validateCode(container);
            if (codeValidationError != null) {
                return codeValidationError;
            }
            String stackValidationError = this.validateStack(container);
            if (stackValidationError == null) continue;
            return stackValidationError;
        }
        return null;
    }

    @Override
    public String validateCode(EOFLayout eofLayout) {
        if (!eofLayout.isValid()) {
            return "Invalid EOF container - " + eofLayout.invalidReason();
        }
        for (CodeSection cs : eofLayout.codeSections()) {
            String validation = this.validateCode(eofLayout.container().slice(cs.getEntryPoint(), cs.getLength()), cs, eofLayout);
            if (validation == null) continue;
            return validation;
        }
        return null;
    }

    String validateCode(Bytes code, CodeSection thisCodeSection, EOFLayout eofLayout) {
        int size = code.size();
        BitSet rjumpdests = new BitSet(size);
        BitSet immediates = new BitSet(size);
        byte[] rawCode = code.toArrayUnsafe();
        OpcodeInfo opcodeInfo = OpcodeInfo.V1_OPCODES[254];
        int pos = 0;
        EOFLayout.EOFContainerMode eofContainerMode = eofLayout.containerMode().get();
        boolean hasReturningOpcode = false;
        while (pos < size) {
            int operationNum = rawCode[pos] & 0xFF;
            opcodeInfo = OpcodeInfo.V1_OPCODES[operationNum];
            if (!opcodeInfo.valid()) {
                return String.format("undefined_instruction 0x%02x", operationNum);
            }
            int pcPostInstruction = ++pos;
            switch (operationNum) {
                case 0: 
                case 243: {
                    if (eofContainerMode == null) {
                        eofContainerMode = EOFLayout.EOFContainerMode.RUNTIME;
                        eofLayout.containerMode().set(EOFLayout.EOFContainerMode.RUNTIME);
                        break;
                    }
                    if (eofContainerMode.equals((Object)EOFLayout.EOFContainerMode.RUNTIME)) break;
                    return String.format("incompatible_container_kind opcode %s is only valid for runtime.", opcodeInfo.name());
                }
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: {
                    int multiByteDataLen = operationNum - 95;
                    pcPostInstruction += multiByteDataLen;
                    break;
                }
                case 209: {
                    if (pos + 2 > size) {
                        return "truncated_instruction DATALOADN";
                    }
                    pcPostInstruction += 2;
                    int dataLoadOffset = Words.readBigEndianU16(pos, rawCode);
                    if (dataLoadOffset <= eofLayout.dataLength() - 32) break;
                    return "invalid_dataloadn_index %d + 32 > %d".formatted(dataLoadOffset, eofLayout.dataLength());
                }
                case 224: 
                case 225: {
                    if (pos + 2 > size) {
                        return "truncated_instruction RJUMP";
                    }
                    int offset = Words.readBigEndianI16(pos, rawCode);
                    int rjumpdest = (pcPostInstruction += 2) + offset;
                    if (rjumpdest < 0 || rjumpdest >= size) {
                        return "invalid_rjump_destination out of bounds";
                    }
                    rjumpdests.set(rjumpdest);
                    break;
                }
                case 226: {
                    if (++pcPostInstruction > size) {
                        return "truncated_instruction RJUMPV";
                    }
                    int jumpBasis = pcPostInstruction;
                    int jumpTableSize = RelativeJumpVectorOperation.getVectorSize(code, pos);
                    if ((pcPostInstruction += 2 * jumpTableSize) > size) {
                        return "truncated_instruction RJUMPV";
                    }
                    for (int offsetPos = jumpBasis; offsetPos < pcPostInstruction; offsetPos += 2) {
                        int rjumpvOffset = Words.readBigEndianI16(offsetPos, rawCode);
                        int rjumpvDest = pcPostInstruction + rjumpvOffset;
                        if (rjumpvDest < 0 || rjumpvDest >= size) {
                            return "invalid_rjump_destination out of bounds";
                        }
                        rjumpdests.set(rjumpvDest);
                    }
                    break;
                }
                case 227: {
                    if (pos + 2 > size) {
                        return "truncated_instruction CALLF";
                    }
                    int section = Words.readBigEndianU16(pos, rawCode);
                    if (section >= eofLayout.getCodeSectionCount()) {
                        return "invalid_code_section_index CALLF to " + Integer.toHexString(section);
                    }
                    if (!eofLayout.getCodeSection((int)section).returning) {
                        return "CALLF to non-returning section - " + Integer.toHexString(section);
                    }
                    pcPostInstruction += 2;
                    break;
                }
                case 228: {
                    hasReturningOpcode = true;
                    break;
                }
                case 229: {
                    if (pos + 2 > size) {
                        return "truncated_instruction JUMPF";
                    }
                    int targetSection = Words.readBigEndianU16(pos, rawCode);
                    if (targetSection >= eofLayout.getCodeSectionCount()) {
                        return "invalid_code_section_index JUMPF - " + Integer.toHexString(targetSection);
                    }
                    CodeSection targetCodeSection = eofLayout.getCodeSection(targetSection);
                    if (targetCodeSection.isReturning() && !thisCodeSection.isReturning()) {
                        return "invalid_non_returning_flag non-returning JUMPF source must have non-returning target";
                    }
                    if (thisCodeSection.getOutputs() < targetCodeSection.getOutputs()) {
                        return String.format("jumpf_destination_incompatible_outputs target %2x with more outputs %d than current section's outputs %d", targetSection, targetCodeSection.getOutputs(), thisCodeSection.getOutputs());
                    }
                    hasReturningOpcode |= eofLayout.getCodeSection(targetSection).isReturning();
                    pcPostInstruction += 2;
                    break;
                }
                case 236: {
                    if (pos + 1 > size) {
                        return String.format("truncated_instruction dangling immediate for %s at pc=%d", opcodeInfo.name(), pos - opcodeInfo.pcAdvance());
                    }
                    int subcontainerNum = rawCode[pos] & 0xFF;
                    if (subcontainerNum >= eofLayout.getSubcontainerCount()) {
                        return String.format("invalid_container_section_index %s refers to non-existent subcontainer %d at pc=%d", opcodeInfo.name(), subcontainerNum, pos - opcodeInfo.pcAdvance());
                    }
                    EOFLayout subContainer = eofLayout.getSubcontainer(subcontainerNum);
                    EOFLayout.EOFContainerMode subcontainerMode = subContainer.containerMode().get();
                    if (subcontainerMode == null) {
                        subContainer.containerMode().set(EOFLayout.EOFContainerMode.INITCODE);
                    } else if (subcontainerMode == EOFLayout.EOFContainerMode.RUNTIME) {
                        return String.format("incompatible_container_kind subcontainer %d should be initcode", subcontainerNum);
                    }
                    if (subContainer.dataLength() != subContainer.data().size()) {
                        return String.format("A subcontainer used for %s has a truncated data section, expected %d and is %d.", OpcodeInfo.V1_OPCODES[operationNum].name(), subContainer.dataLength(), subContainer.data().size());
                    }
                    ++pcPostInstruction;
                    break;
                }
                case 238: {
                    if (eofContainerMode == null) {
                        eofContainerMode = EOFLayout.EOFContainerMode.INITCODE;
                        eofLayout.containerMode().set(EOFLayout.EOFContainerMode.INITCODE);
                    } else if (!eofContainerMode.equals((Object)EOFLayout.EOFContainerMode.INITCODE)) {
                        return String.format("incompatible_container_kind opcode %s is only valid for initcode", opcodeInfo.name());
                    }
                    if (pos + 1 > size) {
                        return String.format("truncated_instruction dangling immediate for %s at pc=%d", opcodeInfo.name(), pos - opcodeInfo.pcAdvance());
                    }
                    int returnedContractNum = rawCode[pos] & 0xFF;
                    if (returnedContractNum >= eofLayout.getSubcontainerCount()) {
                        return String.format("invalid_container_section_index %s refers to non-existent subcontainer %d at pc=%d", opcodeInfo.name(), returnedContractNum, pos - opcodeInfo.pcAdvance());
                    }
                    EOFLayout returnedContract = eofLayout.getSubcontainer(returnedContractNum);
                    EOFLayout.EOFContainerMode returnedContractMode = returnedContract.containerMode().get();
                    if (returnedContractMode == null) {
                        returnedContract.containerMode().set(EOFLayout.EOFContainerMode.RUNTIME);
                    } else if (returnedContractMode.equals((Object)EOFLayout.EOFContainerMode.INITCODE)) {
                        return String.format("incompatible_container_kind subcontainer %d should be runtime", returnedContractNum);
                    }
                    ++pcPostInstruction;
                    break;
                }
                default: {
                    if (opcodeInfo.pcAdvance() <= 1 || (pcPostInstruction += opcodeInfo.pcAdvance() - 1) <= size) break;
                    return String.format("truncated_instruction dangling immediate for %s at pc=%d", opcodeInfo.name(), pos - opcodeInfo.pcAdvance());
                }
            }
            immediates.set(pos, pcPostInstruction);
            pos = pcPostInstruction;
        }
        if (thisCodeSection.isReturning() != hasReturningOpcode) {
            return thisCodeSection.isReturning() ? "unreachable_code_sections no RETF or qualifying JUMPF" : "invalid_non_returning_flag RETF or JUMPF into returning section";
        }
        if (!opcodeInfo.terminal()) {
            return "missing_stop_opcode No terminating instruction";
        }
        if (rjumpdests.intersects(immediates)) {
            return "invalid_rjump_destination targets immediate data";
        }
        return null;
    }

    @Override
    @Nullable
    public String validateStack(EOFLayout eofLayout) {
        WorkList workList = new WorkList(eofLayout.getCodeSectionCount());
        workList.put(0);
        int sectionToValidatie = workList.take();
        while (sectionToValidatie >= 0) {
            String validation = this.validateStack(sectionToValidatie, eofLayout, workList);
            if (validation != null) {
                return validation;
            }
            sectionToValidatie = workList.take();
        }
        if (!workList.isComplete()) {
            return String.format("Unreachable code section %d", workList.getFirstUnmarkedItem());
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    String validateStack(int codeSectionToValidate, EOFLayout eofLayout, WorkList workList) {
        if (!eofLayout.isValid()) {
            return "EOF Layout invalid - " + eofLayout.invalidReason();
        }
        try {
            toValidate = eofLayout.getCodeSection(codeSectionToValidate);
            code = eofLayout.container().slice(toValidate.entryPoint, toValidate.length).toArrayUnsafe();
            codeLength = code.length;
            stack_min = new int[codeLength];
            stack_max = new int[codeLength];
            Arrays.fill(stack_min, 1025);
            Arrays.fill(stack_max, -1);
            maxStackHeight = initialStackHeight = toValidate.getInputs();
            stack_min[0] = initialStackHeight;
            stack_max[0] = initialStackHeight;
            unusedBytes = codeLength;
            currentPC = 0;
            currentMin = initialStackHeight;
            currentMax = initialStackHeight;
            while (currentPC < codeLength) {
                thisOp = code[currentPC] & 255;
                opcodeInfo = OpcodeInfo.V1_OPCODES[thisOp];
                pcAdvance = opcodeInfo.pcAdvance();
                switch (thisOp) {
                    case 227: {
                        section = Words.readBigEndianU16(currentPC + 1, code);
                        workList.put(section);
                        codeSection = eofLayout.getCodeSection(section);
                        stackInputs = codeSection.getInputs();
                        stackOutputs = codeSection.getOutputs();
                        sectionStackUsed = codeSection.getMaxStackHeight();
                        break;
                    }
                    case 230: {
                        depth = code[currentPC + 1] & 255;
                        stackInputs = depth + 1;
                        stackOutputs = depth + 2;
                        sectionStackUsed = 0;
                        break;
                    }
                    case 231: {
                        stackInputs = swapDepth = 2 + (code[currentPC + 1] & 255);
                        stackOutputs = swapDepth;
                        sectionStackUsed = 0;
                        break;
                    }
                    case 232: {
                        imm = code[currentPC + 1] & 255;
                        stackInputs = exchangeDepth = (imm >> 4) + (imm & 15) + 3;
                        stackOutputs = exchangeDepth;
                        sectionStackUsed = 0;
                        break;
                    }
                    default: {
                        stackInputs = opcodeInfo.inputs();
                        stackOutputs = opcodeInfo.outputs();
                        sectionStackUsed = 0;
                    }
                }
                if (!opcodeInfo.valid()) {
                    return String.format("undefined_instruction 0x%02x", new Object[]{thisOp});
                }
                nextPC = currentPC + pcAdvance;
                if (nextPC > codeLength) {
                    return String.format("Dangling immediate argument for opcode 0x%x at PC %d in code section %d.", new Object[]{thisOp, currentPC - pcAdvance, codeSectionToValidate});
                }
                if (stack_max[currentPC] < 0) {
                    return String.format("unreachable_instructions section 0x%x pc %d was not forward referenced", new Object[]{codeSectionToValidate, currentPC});
                }
                currentMin = Math.min(stack_min[currentPC], currentMin);
                currentMax = Math.max(stack_max[currentPC], currentMax);
                if (stackInputs > currentMin) {
                    return String.format("stack_underflow operation 0x%02X wants stack of %d but may only have %d", new Object[]{thisOp, stackInputs, currentMin});
                }
                stackDelta = stackOutputs - stackInputs;
                currentMin += stackDelta;
                if ((currentMax += stackDelta) + sectionStackUsed - stackOutputs > 1024) {
                    return "Stack height exceeds 1024";
                }
                unusedBytes -= pcAdvance;
                maxStackHeight = Math.max(maxStackHeight, currentMax);
                switch (thisOp) {
                    case 224: {
                        jValue = Words.readBigEndianI16(currentPC + 1, code);
                        targetPC = nextPC + jValue;
                        if (targetPC > currentPC) {
                            stack_min[targetPC] = Math.min(stack_min[targetPC], currentMin);
                            stack_max[targetPC] = Math.max(stack_max[targetPC], currentMax);
                        } else {
                            if (stack_min[targetPC] != currentMin) {
                                return String.format("stack_height_mismatch backwards RJUMP from %d to %d, min %d != %d", new Object[]{currentPC, targetPC, stack_min[targetPC], currentMin});
                            }
                            if (stack_max[targetPC] != currentMax) {
                                return String.format("stack_height_mismatch backwards RJUMP from %d to %d, max %d != %d", new Object[]{currentPC, targetPC, stack_max[targetPC], currentMax});
                            }
                        }
                        if (nextPC >= codeLength) break;
                        currentMax = stack_max[nextPC];
                        currentMin = stack_min[nextPC];
                        break;
                    }
                    case 225: {
                        stack_max[nextPC] = Math.max(stack_max[nextPC], currentMax);
                        stack_min[nextPC] = Math.min(stack_min[nextPC], currentMin);
                        jiValue = Words.readBigEndianI16(currentPC + 1, code);
                        targetPCi = nextPC + jiValue;
                        if (targetPCi > currentPC) {
                            stack_min[targetPCi] = Math.min(stack_min[targetPCi], currentMin);
                            stack_max[targetPCi] = Math.max(stack_max[targetPCi], currentMax);
                            break;
                        }
                        if (stack_min[targetPCi] != currentMin) {
                            return String.format("stack_height_mismatch backwards RJUMPI from %d to %d, min %d != %d", new Object[]{currentPC, targetPCi, stack_min[targetPCi], currentMin});
                        }
                        if (stack_max[targetPCi] == currentMax) break;
                        return String.format("stack_height_mismatch backwards RJUMPI from %d to %d, max %d != %d", new Object[]{currentPC, targetPCi, stack_max[targetPCi], currentMax});
                    }
                    case 226: {
                        immediateDataSize = (code[currentPC + 1] & 255) * 2;
                        unusedBytes -= immediateDataSize + 2;
                        nextPC = tableEnd = immediateDataSize + currentPC + 4;
                        stack_max[nextPC] = Math.max(stack_max[nextPC], currentMax);
                        stack_min[nextPC] = Math.min(stack_min[nextPC], currentMin);
                        for (i = currentPC + 2; i < tableEnd; i += 2) {
                            vValue = Words.readBigEndianI16(i, code);
                            targetPCv = tableEnd + vValue;
                            if (targetPCv > currentPC) {
                                stack_min[targetPCv] = Math.min(stack_min[targetPCv], currentMin);
                                stack_max[targetPCv] = Math.max(stack_max[targetPCv], currentMax);
                                continue;
                            }
                            if (stack_min[targetPCv] != currentMin) {
                                return String.format("stack_height_mismatch backwards RJUMPV from %d to %d, min %d != %d", new Object[]{currentPC, targetPCv, stack_min[targetPCv], currentMin});
                            }
                            if (stack_max[targetPCv] == currentMax) continue;
                            return String.format("stack_height_mismatch backwards RJUMPV from %d to %d, max %d != %d", new Object[]{currentPC, targetPCv, stack_max[targetPCv], currentMax});
                        }
                        break;
                    }
                    case 228: {
                        returnStackItems = toValidate.getOutputs();
                        if (currentMin != currentMax) {
                            return String.format("RETF in section %d has a stack range (%d/%d)and must have only one stack value", new Object[]{codeSectionToValidate, currentMin, currentMax});
                        }
                        if (stack_min[currentPC] != returnStackItems || stack_min[currentPC] != stack_max[currentPC]) {
                            return String.format("stack_higher_than_outputs RETF in section %d calculated height %d does not match configured return stack %d, min height %d, and max height %d", new Object[]{codeSectionToValidate, currentMin, returnStackItems, stack_min[currentPC], stack_max[currentPC]});
                        }
                        if (nextPC >= codeLength) break;
                        currentMax = stack_max[nextPC];
                        currentMin = stack_min[nextPC];
                        break;
                    }
                    case 229: {
                        jumpFTargetSectionNum = Words.readBigEndianI16(currentPC + 1, code);
                        workList.put(jumpFTargetSectionNum);
                        targetCs = eofLayout.getCodeSection(jumpFTargetSectionNum);
                        if (currentMax + targetCs.getMaxStackHeight() - targetCs.getInputs() > 1024) {
                            return String.format("JUMPF at section %d pc %d would exceed maximum stack with %d items", new Object[]{codeSectionToValidate, currentPC, currentMax + targetCs.getMaxStackHeight() - targetCs.getInputs()});
                        }
                        if (!targetCs.isReturning()) ** GOTO lbl139
                        if (currentMin != currentMax) {
                            return String.format("JUMPF at section %d pc %d has a variable stack height %d/%d", new Object[]{codeSectionToValidate, currentPC, currentMin, currentMax});
                        }
                        expectedMax = toValidate.outputs + targetCs.inputs - targetCs.outputs;
                        if (currentMax != expectedMax) {
                            return String.format("%s JUMPF at section %d pc %d has incompatible stack height for returning section %d (%d != %d + %d - %d)", new Object[]{currentMax < expectedMax ? "stack_underflow" : "stack_higher_than_outputs", codeSectionToValidate, currentPC, jumpFTargetSectionNum, currentMax, toValidate.outputs, targetCs.inputs, targetCs.outputs});
                        }
                        ** GOTO lbl141
lbl139:
                        // 1 sources

                        if (currentMin < targetCs.getInputs()) {
                            return String.format("stack_underflow JUMPF at section %d pc %d has insufficient minimum stack height for non returning section %d (%d != %d)", new Object[]{codeSectionToValidate, currentPC, jumpFTargetSectionNum, currentMin, targetCs.inputs});
                        }
                    }
lbl141:
                    // 4 sources

                    case 0: 
                    case 238: 
                    case 243: 
                    case 253: 
                    case 254: {
                        if (nextPC >= codeLength) break;
                        currentMax = stack_max[nextPC];
                        currentMin = stack_min[nextPC];
                        break;
                    }
                    default: {
                        if (nextPC >= codeLength) break;
                        stack_max[nextPC] = currentMax = Math.max(stack_max[nextPC], currentMax);
                        currentMin = Math.min(stack_min[nextPC], currentMin);
                        stack_min[nextPC] = Math.min(stack_min[nextPC], currentMin);
                    }
                }
                currentPC = nextPC;
            }
            if (maxStackHeight != toValidate.maxStackHeight) {
                return String.format("invalid_max_stack_height Calculated (%d) != reported (%d)", new Object[]{maxStackHeight, toValidate.maxStackHeight});
            }
            if (unusedBytes != 0) {
                return String.format("Dead code detected in section %d", new Object[]{codeSectionToValidate});
            }
            return null;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            return "Internal Exception " + re.getMessage();
        }
    }
}

