/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http2;

import io.helidon.common.GenericType;
import io.helidon.common.buffers.BufferData;
import io.helidon.http.Headers;
import io.helidon.http.ServerRequestHeaders;
import io.helidon.http.media.MediaContext;
import io.helidon.http.media.ReadableEntity;
import io.helidon.http.media.ReadableEntityBase;
import java.io.InputStream;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public final class Http2ServerRequestEntity
extends ReadableEntityBase
implements ReadableEntity {
    private final ServerRequestHeaders requestHeaders;
    private final MediaContext mediaContext;
    private final UnaryOperator<InputStream> decoder;
    private final UnaryOperator<InputStream> streamFilter;

    private Http2ServerRequestEntity(UnaryOperator<InputStream> streamFilter, UnaryOperator<InputStream> decoder, Function<Integer, BufferData> readEntityFunction, Runnable entityProcessedRunnable, ServerRequestHeaders requestHeaders, MediaContext mediaContext) {
        super(readEntityFunction, entityProcessedRunnable);
        this.streamFilter = streamFilter;
        this.decoder = decoder;
        this.requestHeaders = requestHeaders;
        this.mediaContext = mediaContext;
    }

    public static Http2ServerRequestEntity create(UnaryOperator<InputStream> streamFilter, UnaryOperator<InputStream> decoder, Function<Integer, BufferData> readEntityFunction, Runnable entityProcessedRunnable, ServerRequestHeaders requestHeaders, MediaContext mediaContext) {
        return new Http2ServerRequestEntity(streamFilter, decoder, readEntityFunction, entityProcessedRunnable, requestHeaders, mediaContext);
    }

    public ReadableEntity copy(Runnable entityProcessedRunnable) {
        return new Http2ServerRequestEntity(this.streamFilter, this.decoder, this.readEntityFunction(), () -> {
            entityProcessedRunnable.run();
            this.entityProcessedRunnable().run();
        }, this.requestHeaders, this.mediaContext);
    }

    public InputStream inputStream() {
        return (InputStream)this.streamFilter.apply((InputStream)this.decoder.apply(super.inputStream()));
    }

    protected <T> T entityAs(GenericType<T> type) {
        return (T)this.mediaContext.reader(type, (Headers)this.requestHeaders).read(type, this.inputStream(), (Headers)this.requestHeaders);
    }
}

