/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkle.test.fixtures.map.dummy;

import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.impl.PartialMerkleLeaf;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Objects;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class SimpleValue
extends PartialMerkleLeaf
implements MerkleLeaf {
    private static final long CLASS_ID = -7749021897041751254L;
    protected static final int EXTENDED_VALUE_TYPE = 501;
    protected static final int VALUE_VERSION = 10;
    private long balance;
    private long sendThresholdValue;
    private long receiveThresholdValue;

    public SimpleValue() {
    }

    SimpleValue(ValueBuilder valueBuilder) {
        this.balance = valueBuilder.balance;
        this.sendThresholdValue = valueBuilder.sendThresholdValue;
        this.receiveThresholdValue = valueBuilder.receiveThresholdValue;
    }

    SimpleValue(long balance, long sendThresholdValue, long receiveThresholdValue) {
        this.balance = balance;
        this.sendThresholdValue = sendThresholdValue;
        this.receiveThresholdValue = receiveThresholdValue;
    }

    private SimpleValue(SimpleValue sourceValue) {
        super((PartialMerkleLeaf)sourceValue);
        this.balance = sourceValue.getBalance();
        this.sendThresholdValue = sourceValue.getSendThresholdValue();
        this.receiveThresholdValue = sourceValue.getReceiveThresholdValue();
        this.setImmutable(false);
        sourceValue.setImmutable(true);
    }

    public static SimpleValue deserialize(DataInputStream inputStream) throws IOException {
        int valueVersion = inputStream.readInt();
        if (valueVersion != 10) {
            throw new IOException(String.format("Invalid value version. Expected %d. Received %d", 501, valueVersion));
        }
        inputStream.readInt();
        return SimpleValue.deserializeValue(inputStream);
    }

    protected static SimpleValue deserializeValue(DataInputStream inputStream) throws IOException {
        return ((ValueBuilder)((ValueBuilder)((ValueBuilder)((ValueBuilder)SimpleValue.newBuilder().setBalance(inputStream.readLong())).setSendThresholdvalue(inputStream.readLong())).setReceiveThresholdValue(inputStream.readLong())).setReceiveSignatureRequired(inputStream.readByte() == 1)).build();
    }

    public static ValueBuilder newBuilder() {
        return new ValueBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SimpleValue value = (SimpleValue)((Object)o);
        return this.balance == value.balance && this.sendThresholdValue == value.sendThresholdValue && this.receiveThresholdValue == value.receiveThresholdValue;
    }

    public int hashCode() {
        return Objects.hash(this.balance, this.sendThresholdValue, this.receiveThresholdValue);
    }

    public String toString() {
        return "Value{balance=" + this.balance + ", sendThresholdValue=" + this.sendThresholdValue + ", receiveThresholdValue=" + this.receiveThresholdValue + "}";
    }

    public long getBalance() {
        return this.balance;
    }

    public long getSendThresholdValue() {
        return this.sendThresholdValue;
    }

    public long getReceiveThresholdValue() {
        return this.receiveThresholdValue;
    }

    public long getClassId() {
        return -7749021897041751254L;
    }

    public int getVersion() {
        return 1;
    }

    public void serialize(SerializableDataOutputStream outStream) throws IOException {
        outStream.writeLong(this.balance);
        outStream.writeLong(this.sendThresholdValue);
        outStream.writeLong(this.receiveThresholdValue);
    }

    public void deserialize(SerializableDataInputStream inputStream, int version) throws IOException {
        this.balance = inputStream.readLong();
        this.sendThresholdValue = inputStream.readLong();
        this.receiveThresholdValue = inputStream.readLong();
    }

    public SimpleValue copy() {
        this.throwIfImmutable();
        return new SimpleValue(this);
    }

    public static class ValueBuilder<T extends ValueBuilder<T>> {
        private long balance;
        private long sendThresholdValue;
        private long receiveThresholdValue;
        private boolean receiveSignatureRequired;

        ValueBuilder() {
        }

        public T setBalance(long balance) {
            this.balance = balance;
            return this.getThis();
        }

        public T setSendThresholdvalue(long sendThresholdValue) {
            this.sendThresholdValue = sendThresholdValue;
            return this.getThis();
        }

        public T setReceiveThresholdValue(long receiveThresholdValue) {
            this.receiveThresholdValue = receiveThresholdValue;
            return this.getThis();
        }

        public T setReceiveSignatureRequired(boolean receiveSignatureRequired) {
            this.receiveSignatureRequired = receiveSignatureRequired;
            return this.getThis();
        }

        public SimpleValue build() {
            return new SimpleValue(this);
        }

        protected T getThis() {
            return (T)this;
        }
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

