/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network;

import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.common.metrics.SpeedometerMetric;
import com.swirlds.common.metrics.extensions.CountPerSecond;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.network.PeerInfo;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.LongAdder;
import org.hiero.consensus.model.node.NodeId;

public class NetworkMetrics {
    private static final String PING_CATEGORY = "ping";
    private static final String BPSS_CATEGORY = "bpss";
    private static final RunningAverageMetric.Config AVG_PING_CONFIG = new RunningAverageMetric.Config("platform", "ping").withDescription("average time for a round trip message between 2 computers (in milliseconds)").withFormat("%,7.0f");
    private static final SpeedometerMetric.Config BYTES_PER_SECOND_SENT_CONFIG = new SpeedometerMetric.Config("internal", "bytes_per_sec_sent").withDescription("number of bytes sent per second over the network (total for this member)").withFormat("%,16.2f");
    private static final RunningAverageMetric.Config AVG_CONNS_CREATED_CONFIG = new RunningAverageMetric.Config("platform", "conns").withDescription("number of times a TLS connections was created").withFormat("%,10.0f").withHalfLife(0.0);
    private final NodeId selfId;
    private final Queue<Connection> connections = new ConcurrentLinkedQueue<Connection>();
    private final LongAdder connsCreated = new LongAdder();
    private final ConcurrentHashMap<NodeId, RunningAverageMetric> avgPingMilliseconds = new ConcurrentHashMap();
    private final ConcurrentHashMap<NodeId, SpeedometerMetric> avgBytePerSecSent = new ConcurrentHashMap();
    private final RunningAverageMetric avgPing;
    private final SpeedometerMetric bytesPerSecondSent;
    private final RunningAverageMetric avgConnsCreated;
    private final ConcurrentHashMap<NodeId, CountPerSecond> disconnectFrequency = new ConcurrentHashMap();
    private final Metrics metrics;

    public NetworkMetrics(@NonNull Metrics metrics, @NonNull NodeId selfId, List<PeerInfo> peers) {
        this.selfId = Objects.requireNonNull(selfId, "The selfId must not be null.");
        this.metrics = Objects.requireNonNull(metrics, "The metrics must not be null.");
        this.avgPing = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_PING_CONFIG);
        this.bytesPerSecondSent = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)BYTES_PER_SECOND_SENT_CONFIG);
        this.avgConnsCreated = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_CONNS_CREATED_CONFIG);
        this.precreateDynamicMetrics(peers);
    }

    private void precreateDynamicMetrics(List<PeerInfo> peers) {
        for (PeerInfo peer : peers) {
            NodeId nodeId = peer.nodeId();
            this.recordPingTime(nodeId, 0L);
            this.getDisconnectMetric(nodeId);
            this.getAverageBytesPerSecondSentMetric(nodeId);
        }
    }

    public void connectionEstablished(@Nullable Connection connection) {
        if (connection == null) {
            return;
        }
        this.connections.add(connection);
        this.connsCreated.increment();
    }

    public void recordPingTime(@NonNull NodeId node, long pingNanos) {
        Objects.requireNonNull(node, "The node must not be null.");
        this.avgPingMilliseconds.computeIfAbsent(node, nodeId -> (RunningAverageMetric)this.metrics.getOrCreate((MetricConfig)new RunningAverageMetric.Config(PING_CATEGORY, String.format("ping_ms_%02d", nodeId.id())).withDescription(String.format("milliseconds to send node %02d a byte and receive a reply", nodeId.id())).withFormat("%,4.2f"))).update((double)pingNanos / 1000000.0);
    }

    public void update() {
        double sum = 0.0;
        int count = 0;
        for (RunningAverageMetric metric : this.avgPingMilliseconds.values()) {
            if (metric == null) continue;
            sum += metric.get();
            ++count;
        }
        if (count > 1) {
            double pingValue = sum / (double)(count - 1);
            this.avgPing.update(pingValue);
        } else {
            this.avgPing.update(0.0);
        }
        long totalBytesSent = 0L;
        Iterator iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            Connection conn = (Connection)iterator.next();
            if (conn == null) continue;
            long bytesSent = conn.getDos().getConnectionByteCounter().getAndResetCount();
            totalBytesSent += bytesSent;
            NodeId otherId = conn.getOtherId();
            this.getAverageBytesPerSecondSentMetric(otherId).update((double)bytesSent);
            if (conn.connected()) continue;
            iterator.remove();
        }
        this.bytesPerSecondSent.update((double)totalBytesSent);
        this.avgConnsCreated.update((double)this.connsCreated.sum());
    }

    private SpeedometerMetric getAverageBytesPerSecondSentMetric(NodeId otherId) {
        return this.avgBytePerSecSent.computeIfAbsent(otherId, nodeId -> (SpeedometerMetric)this.metrics.getOrCreate((MetricConfig)new SpeedometerMetric.Config(BPSS_CATEGORY, String.format("bytes_per_sec_sent_%02d", nodeId.id())).withDescription(String.format("bytes per second sent to node %02d", nodeId.id())).withFormat("%,16.2f")));
    }

    @NonNull
    public Map<NodeId, Double> getAvgPingMilliseconds() {
        HashMap<NodeId, Double> times = new HashMap<NodeId, Double>();
        this.avgPingMilliseconds.forEach((nodeId, metric) -> times.put((NodeId)nodeId, metric.get()));
        times.put(this.selfId, 0.0);
        return times;
    }

    public void recordDisconnect(@NonNull Connection connection) {
        NodeId otherId = Objects.requireNonNull(connection, "connection must not be null.").getOtherId();
        this.getDisconnectMetric(otherId).count();
    }

    private CountPerSecond getDisconnectMetric(NodeId otherId) {
        return this.disconnectFrequency.computeIfAbsent(otherId, nodeId -> new CountPerSecond(this.metrics, new CountPerSecond.Config("platform", String.format("disconnects_per_sec_%02d", nodeId.id())).withDescription(String.format("number of disconnects per second from node %02d", nodeId.id())).withFormat("%,10.0f")));
    }
}

