/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.extensions.sources;

import com.swirlds.config.extensions.sources.AbstractFileConfigSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.Objects;

public class ClasspathFileConfigSource
extends AbstractFileConfigSource {
    public ClasspathFileConfigSource(@NonNull Path filePath) throws IOException {
        super(filePath);
    }

    public ClasspathFileConfigSource(@NonNull Path filePath, int ordinal) throws IOException {
        super(filePath, ordinal);
    }

    @Override
    @NonNull
    protected BufferedReader getReader() {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.filePath.toString());
        Objects.requireNonNull(inputStream, "Could not load properties from classpath resource " + String.valueOf(this.filePath));
        return new BufferedReader(new InputStreamReader(inputStream));
    }
}

