/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.base.test.fixtures.io.internal;

import com.swirlds.base.test.fixtures.io.SystemErrProvider;
import com.swirlds.base.test.fixtures.io.SystemOutProvider;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.ByteArrayOutputStream;
import java.util.Objects;
import java.util.stream.Stream;

public class SystemIoProvider
implements SystemOutProvider,
SystemErrProvider {
    private final StringBuilder internalBuilder = new StringBuilder();
    private boolean readAll = false;
    private final ByteArrayOutputStream outputStream;

    public SystemIoProvider(@NonNull ByteArrayOutputStream outputStream) {
        this.outputStream = Objects.requireNonNull(outputStream, "outputStream must not be null");
    }

    private void readAll() {
        try {
            this.internalBuilder.setLength(0);
            this.internalBuilder.append(this.outputStream.toString());
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading from outputStream", e);
        }
        finally {
            this.readAll = true;
        }
    }

    @Override
    public Stream<String> getLines() {
        if (!this.readAll) {
            this.readAll();
        }
        return this.internalBuilder.toString().lines();
    }
}

