/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.schedulers;

import com.swirlds.component.framework.model.TraceableWiringModel;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.component.framework.schedulers.internal.DefaultSquelcher;
import com.swirlds.component.framework.schedulers.internal.Squelcher;
import com.swirlds.component.framework.schedulers.internal.ThrowingSquelcher;
import com.swirlds.component.framework.wires.input.BindableInputWire;
import com.swirlds.component.framework.wires.input.TaskSchedulerInput;
import com.swirlds.component.framework.wires.output.OutputWire;
import com.swirlds.component.framework.wires.output.StandardOutputWire;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public abstract class TaskScheduler<OUT>
extends TaskSchedulerInput<OUT> {
    private final boolean flushEnabled;
    private final TraceableWiringModel model;
    private final String name;
    private final TaskSchedulerType type;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final StandardOutputWire<OUT> primaryOutputWire;
    private final boolean insertionIsBlocking;
    private final Squelcher squelcher;

    protected TaskScheduler(@NonNull TraceableWiringModel model, @NonNull String name, @NonNull TaskSchedulerType type, @NonNull Thread.UncaughtExceptionHandler uncaughtExceptionHandler, boolean flushEnabled, boolean squelchingEnabled, boolean insertionIsBlocking) {
        this.model = Objects.requireNonNull(model);
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
        this.uncaughtExceptionHandler = Objects.requireNonNull(uncaughtExceptionHandler);
        this.flushEnabled = flushEnabled;
        this.squelcher = squelchingEnabled ? new DefaultSquelcher() : new ThrowingSquelcher();
        this.primaryOutputWire = this.buildPrimaryOutputWire(model, name);
        this.insertionIsBlocking = insertionIsBlocking;
    }

    @NonNull
    public <I> BindableInputWire<I, OUT> buildInputWire(@NonNull String name) {
        return new BindableInputWire(this.model, this, name);
    }

    @NonNull
    protected StandardOutputWire<OUT> buildPrimaryOutputWire(@NonNull TraceableWiringModel model, @NonNull String name) {
        return new StandardOutputWire(model, name, this.getUncaughtExceptionHandler());
    }

    @NonNull
    public OutputWire<OUT> getOutputWire() {
        return this.primaryOutputWire;
    }

    @NonNull
    public <T> StandardOutputWire<T> buildSecondaryOutputWire() {
        return new StandardOutputWire(this.model, this.name, this.getUncaughtExceptionHandler());
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public TaskSchedulerType getType() {
        return this.type;
    }

    @NonNull
    protected Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler;
    }

    public boolean isInsertionBlocking() {
        return this.insertionIsBlocking;
    }

    public abstract long getUnprocessedTaskCount();

    public abstract long getCapacity();

    public abstract void flush();

    protected final void throwIfFlushDisabled() {
        if (!this.flushEnabled) {
            throw new UnsupportedOperationException("Flushing is not enabled for the task scheduler " + this.name);
        }
    }

    public void startSquelching() {
        this.squelcher.startSquelching();
    }

    public void stopSquelching() {
        this.squelcher.stopSquelching();
    }

    public final boolean currentlySquelching() {
        return this.squelcher.shouldSquelch();
    }

    @Override
    protected void forward(@NonNull OUT data) {
        this.primaryOutputWire.forward(data);
    }
}

