/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.state;

import com.swirlds.common.test.fixtures.platform.TestPlatformContextBuilder;
import com.swirlds.platform.crypto.CryptoStatic;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.test.fixtures.PlatformStateUtils;
import com.swirlds.platform.test.fixtures.state.TestingAppStateInitializer;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import com.swirlds.state.merkle.VirtualMapState;
import com.swirlds.state.test.fixtures.merkle.VirtualMapStateTestUtils;
import java.util.Random;
import org.hiero.base.crypto.test.fixtures.CryptoRandomUtils;

public class SignedStateUtils {
    public static SignedState randomSignedState(long seed) {
        return SignedStateUtils.randomSignedState(new Random(seed));
    }

    public static SignedState randomSignedState(Random random) {
        VirtualMapState root = VirtualMapStateTestUtils.createTestState();
        TestingAppStateInitializer.initPlatformState((MerkleNodeState)root);
        PlatformStateUtils.randomPlatformState(random, (State)root);
        boolean shouldSaveToDisk = random.nextBoolean();
        SignedState signedState = new SignedState(TestPlatformContextBuilder.create().build().getConfiguration(), CryptoStatic::verifySignature, (MerkleNodeState)root, "test", shouldSaveToDisk, false, false);
        signedState.getState().setHash(CryptoRandomUtils.randomHash((Random)random));
        return signedState;
    }
}

