/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.crypto;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.HashBuilder;
import org.hiero.base.crypto.SerializableHashable;
import org.hiero.base.crypto.SignatureType;
import org.hiero.base.crypto.TransactionSignature;
import org.hiero.base.io.SelfSerializable;

public interface Cryptography {
    public static final boolean DEFAULT_SET_HASH = true;
    public static final DigestType DEFAULT_DIGEST_TYPE = DigestType.SHA_384;
    public static final Hash NULL_HASH = new HashBuilder(DEFAULT_DIGEST_TYPE).build();

    @NonNull
    public Hash digestSync(@NonNull byte[] var1);

    default public Hash digestSync(@NonNull SelfSerializable serializable) {
        return new Hash(this.digestBytesSync(serializable), DEFAULT_DIGEST_TYPE);
    }

    public byte[] digestBytesSync(@NonNull SelfSerializable var1);

    public Hash digestSync(@NonNull SerializableHashable var1, boolean var2);

    default public Hash digestSync(@NonNull SerializableHashable serializableHashable) {
        return this.digestSync(serializableHashable, true);
    }

    @NonNull
    public byte[] digestBytesSync(@NonNull byte[] var1);

    public boolean verifySync(@NonNull TransactionSignature var1);

    public boolean verifySync(@NonNull List<TransactionSignature> var1);

    default public boolean verifySync(@NonNull byte[] data, @NonNull byte[] signature, @NonNull byte[] publicKey) {
        return this.verifySync(data, signature, publicKey, SignatureType.ED25519);
    }

    public boolean verifySync(@NonNull byte[] var1, @NonNull byte[] var2, @NonNull byte[] var3, @NonNull SignatureType var4);

    @NonNull
    public Hash calcRunningHash(@NonNull Hash var1, @NonNull Hash var2);
}

