/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.cli;

import com.swirlds.cli.commands.LogCommand;
import com.swirlds.cli.logging.LogProcessor;
import com.swirlds.cli.utility.AbstractCommand;
import com.swirlds.cli.utility.SubcommandOf;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import picocli.CommandLine;

@CommandLine.Command(name="format", mixinStandardHelpOptions=true, description={"Generate an html formatted version of swirlds log files."})
@SubcommandOf(value=LogCommand.class)
public class FormatSwirldsLogCommand
extends AbstractCommand {
    private Path inputDirectory;
    private Path outputPath;

    @CommandLine.Option(names={"-i", "--input"}, description={"The path to the root directory where the input log files are contained.Defaults to the current working directory"})
    private void setInputDirectory(@NonNull Path inputDirectory) {
        if (!Files.isDirectory(inputDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException("Input directory '%s' does not exist, or is not a directory".formatted(inputDirectory));
        }
        this.inputDirectory = Objects.requireNonNull(inputDirectory);
    }

    @CommandLine.Option(names={"-o", "--output"}, description={"Specify the destination for the formatted log file. Defaults the the input directory."})
    private void setOutputPath(@NonNull Path outputPath) {
        Objects.requireNonNull(outputPath);
        this.outputPath = outputPath.toAbsolutePath().normalize();
    }

    public Integer call() throws Exception {
        LogProcessor.processLogs((Path)this.inputDirectory, (Path)this.outputPath);
        return 0;
    }
}

