/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime.io.buffer;

import com.hedera.pbj.runtime.io.DataEncodingException;
import com.hedera.pbj.runtime.io.UnsafeUtils;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

final class DirectBufferedData
extends BufferedData {
    private static final int BULK_COMPARISON_THRESHOLD = 32;

    DirectBufferedData(ByteBuffer buffer) {
        super(buffer);
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Cannot create a DirectBufferedData over a heap byte buffer");
        }
    }

    @Override
    public long getBytes(long offset, @NonNull byte[] dst, int dstOffset, int maxLength) {
        this.validateLen(maxLength);
        long len = Math.min((long)maxLength, this.length() - offset);
        this.checkOffsetToRead(offset, this.length(), len);
        if (len == 0L) {
            return 0L;
        }
        this.checkOffsetToWrite(dstOffset, dst.length, len);
        UnsafeUtils.getDirectBufferToArray(this.buffer, offset, dst, dstOffset, Math.toIntExact(len));
        return len;
    }

    @Override
    public long getBytes(long offset, @NonNull ByteBuffer dst) {
        if (!dst.hasArray()) {
            return super.getBytes(offset, dst);
        }
        this.checkOffset(offset, this.length());
        long len = Math.min(this.length() - offset, (long)dst.remaining());
        byte[] dstArr = dst.array();
        int dstPos = dst.position();
        int dstArrOffset = dst.arrayOffset();
        UnsafeUtils.getDirectBufferToArray(this.buffer, offset, dstArr, dstArrOffset + dstPos, Math.toIntExact(len));
        return len;
    }

    @Override
    @NonNull
    public Bytes getBytes(long offset, long len) {
        this.validateLen(len);
        if (len == 0L) {
            return Bytes.EMPTY;
        }
        this.checkOffsetToRead(offset, this.length(), len);
        byte[] res = new byte[Math.toIntExact(len)];
        UnsafeUtils.getDirectBufferToArray(this.buffer, offset, res, 0, Math.toIntExact(len));
        return Bytes.wrap(res);
    }

    @Override
    public int getVarInt(long offset, boolean zigZag) {
        return (int)this.getVar(Math.toIntExact(offset), zigZag);
    }

    @Override
    public long getVarLong(long offset, boolean zigZag) {
        return this.getVar(Math.toIntExact(offset), zigZag);
    }

    private long getVar(int offset, boolean zigZag) {
        int i;
        this.checkOffset(offset, this.length());
        int rem = Math.toIntExact(this.buffer.limit() - offset);
        if (rem > 10) {
            rem = 10;
        }
        long value = 0L;
        for (i = 0; i != rem; ++i) {
            byte b = UnsafeUtils.getDirectBufferByte(this.buffer, offset + i);
            value |= (long)(b & 0x7F) << i * 7;
            if (b < 0) continue;
            this.buffer.position(offset + i);
            return zigZag ? value >>> 1 ^ -(value & 1L) : value;
        }
        throw i == 10 ? new DataEncodingException("Malformed var int") : new BufferUnderflowException();
    }

    @Override
    public long readBytes(@NonNull byte[] dst, int dstOffset, int maxLength) {
        this.validateLen(maxLength);
        long len = Math.min((long)maxLength, this.remaining());
        int pos = this.buffer.position();
        this.validateCanRead(pos, len);
        if (len == 0L) {
            return 0L;
        }
        if (dstOffset < 0 || (long)(dst.length - dstOffset) < len) {
            throw new IndexOutOfBoundsException();
        }
        UnsafeUtils.getDirectBufferToArray(this.buffer, pos, dst, dstOffset, Math.toIntExact(len));
        this.buffer.position(Math.toIntExact((long)pos + len));
        return len;
    }

    @Override
    public long readBytes(@NonNull ByteBuffer dst) {
        long len = Math.min(this.remaining(), (long)dst.remaining());
        int pos = this.buffer.position();
        int dstPos = dst.position();
        if (dst.hasArray()) {
            byte[] dstArr = dst.array();
            int dstArrOffset = dst.arrayOffset();
            UnsafeUtils.getDirectBufferToArray(this.buffer, pos, dstArr, dstArrOffset + dstPos, Math.toIntExact(len));
            this.buffer.position(Math.toIntExact((long)pos + len));
            dst.position(Math.toIntExact((long)dstPos + len));
            return len;
        }
        if (dst.isDirect()) {
            UnsafeUtils.getDirectBufferToDirectBuffer(this.buffer, pos, dst, dstPos, Math.toIntExact(len));
            this.buffer.position(Math.toIntExact((long)pos + len));
            dst.position(Math.toIntExact((long)dstPos + len));
            return len;
        }
        return super.readBytes(dst);
    }

    @Override
    @NonNull
    public Bytes readBytes(int len) {
        this.validateLen(len);
        if (len == 0) {
            return Bytes.EMPTY;
        }
        int pos = this.buffer.position();
        this.validateCanRead(pos, len);
        byte[] res = new byte[len];
        UnsafeUtils.getDirectBufferToArray(this.buffer, pos, res, 0, len);
        this.buffer.position(pos + len);
        return Bytes.wrap(res);
    }

    @Override
    public int readVarInt(boolean zigZag) {
        return (int)this.readVar(zigZag);
    }

    @Override
    public long readVarLong(boolean zigZag) {
        return this.readVar(zigZag);
    }

    private long readVar(boolean zigZag) {
        int i;
        int pos = this.buffer.position();
        int rem = this.buffer.remaining();
        if (rem > 10) {
            rem = 10;
        }
        long value = 0L;
        for (i = 0; i != rem; ++i) {
            byte b = UnsafeUtils.getDirectBufferByteNoChecks(this.buffer, pos + i);
            value |= (long)(b & 0x7F) << i * 7;
            if (b < 0) continue;
            this.buffer.position(pos + i);
            return zigZag ? value >>> 1 ^ -(value & 1L) : value;
        }
        throw i == 10 ? new DataEncodingException("") : new BufferUnderflowException();
    }

    @Override
    public void writeBytes(@NonNull byte[] src, int offset, int len) {
        Objects.requireNonNull(src);
        this.validateLen(len);
        this.checkOffsetToRead(offset, src.length, len);
        this.validateCanWrite(len);
        int pos = this.buffer.position();
        UnsafeUtils.putByteArrayToDirectBuffer(this.buffer, pos, src, offset, len);
        this.buffer.position(pos + len);
    }

    @Override
    public void writeBytes(@NonNull ByteBuffer src) {
        if (!src.hasArray()) {
            super.writeBytes(src);
            return;
        }
        int len = src.remaining();
        this.validateCanWrite(len);
        int pos = this.buffer.position();
        byte[] srcArr = src.array();
        int srcPos = src.position();
        int srcArrOffset = src.arrayOffset();
        UnsafeUtils.putByteArrayToDirectBuffer(this.buffer, pos, srcArr, srcArrOffset + srcPos, len);
        this.buffer.position(pos + len);
        src.position(srcPos + len);
    }

    private boolean bulkContains(long offset, byte[] compareData, int compareLength) {
        if (compareLength <= 32) {
            return super.contains(offset, compareData);
        }
        byte[] tempArray = new byte[compareLength];
        UnsafeUtils.getDirectBufferToArray(this.buffer, offset, tempArray, 0, compareLength);
        return Arrays.equals(tempArray, compareData);
    }

    @Override
    public boolean contains(long offset, @NonNull byte[] bytes) {
        this.checkOffset(offset, this.length());
        if (this.length() - offset < (long)bytes.length) {
            return false;
        }
        return this.bulkContains(offset, bytes, bytes.length);
    }

    @Override
    public boolean contains(long offset, @NonNull RandomAccessData data) {
        if (this.length() == 0L) {
            return data.length() == 0L;
        }
        this.checkOffset(offset, this.length());
        if (this.length() - offset < data.length()) {
            return false;
        }
        if (data instanceof DirectBufferedData) {
            DirectBufferedData otherDirectData = (DirectBufferedData)data;
            int dataLength = Math.toIntExact(data.length());
            if (dataLength <= 32) {
                return super.contains(offset, data);
            }
            byte[] otherArray = new byte[dataLength];
            UnsafeUtils.getDirectBufferToArray(otherDirectData.buffer, 0L, otherArray, 0, dataLength);
            return this.bulkContains(offset, otherArray, dataLength);
        }
        return super.contains(offset, data);
    }
}

