/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.editor;

import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.common.formatting.TextEffect;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.route.MerkleRouteIterator;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.state.editor.StateEditor;
import com.swirlds.platform.state.editor.StateEditorOperation;
import com.swirlds.platform.state.editor.StateEditorRoot;
import com.swirlds.platform.state.editor.StateEditorUtils;
import com.swirlds.platform.state.signed.ReservedSignedState;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hashable;
import picocli.CommandLine;

@CommandLine.Command(name="exec", mixinStandardHelpOptions=true, description={"Run a function on a node."})
@SubcommandOf(value=StateEditorRoot.class)
public class StateEditorExec
extends StateEditorOperation {
    private static final Logger logger = LogManager.getLogger(StateEditorExec.class);
    private String function = "";
    private String path = "";
    private static final ClassLoader classLoader = StateEditorExec.class.getClassLoader();

    @CommandLine.Parameters(index="0", description={"The fully qualified name of the function to run. Should be a static method that implements the interface Function<MerkleNode, MerkleNode>. The return value, if different than the original, will replace the original node. e.g. com.swirlds.foo.bar.MyClass.myFunction"})
    private void setFunction(String function) {
        this.function = function;
    }

    @CommandLine.Parameters(index="1", arity="0..1", description={"The path of the node to run the function on."})
    private void setPath(String path) {
        this.path = path;
    }

    @Override
    public void run() {
        block10: {
            try {
                MerkleNode result;
                MerkleNode node = this.getStateEditor().getRelativeNode(this.path);
                String className = this.function.substring(0, this.function.lastIndexOf(46));
                String methodName = this.function.substring(this.function.lastIndexOf(46) + 1);
                Class<?> clazz = classLoader.loadClass(className);
                Method method = clazz.getMethod(methodName, MerkleNode.class);
                if (logger.isInfoEnabled(LogMarker.CLI.getMarker())) {
                    logger.info(LogMarker.CLI.getMarker(), "Applying {} to {}", (Object)TextEffect.BRIGHT_CYAN.apply(this.function), (Object)StateEditorUtils.formatNode(node));
                }
                if ((result = (MerkleNode)method.invoke(null, node)) == node) break block10;
                if (logger.isInfoEnabled(LogMarker.CLI.getMarker())) {
                    logger.info(LogMarker.CLI.getMarker(), "Replacing {} with node {} returned by {}()", (Object)StateEditorUtils.formatNode(node), (Object)StateEditorUtils.formatNodeType(result), (Object)methodName);
                }
                StateEditor.ParentInfo parentInfo = this.getStateEditor().getParentInfo(this.path);
                parentInfo.parent().setChild(parentInfo.indexInParent(), result);
                try (ReservedSignedState reservedSignedState = this.getStateEditor().getState("StateEditorExec.run()");){
                    new MerkleRouteIterator(reservedSignedState.get().getState().getRoot(), parentInfo.parent().getRoute()).forEachRemaining(Hashable::invalidateHash);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

