/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.base.test.fixtures.concurrent.internal;

import com.swirlds.base.test.fixtures.concurrent.TestExecutor;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class ConcurrentTestSupport
implements TestExecutor,
AutoCloseable {
    private static final String NAME_PREFIX = ConcurrentTestSupport.class.getSimpleName();
    private static final AtomicInteger ID = new AtomicInteger(0);
    private final Duration maxWaitTime;
    private final ExecutorService executorService;

    public ConcurrentTestSupport(@NonNull Duration maxWaitTime) {
        this.maxWaitTime = Objects.requireNonNull(maxWaitTime, "maxWaitTime must not be null");
        this.executorService = Executors.newCachedThreadPool(r -> {
            Thread thread = new Thread(r);
            thread.setName(NAME_PREFIX + "-pool-" + this.hashCode() + ID.getAndDecrement());
            thread.setDaemon(true);
            return thread;
        });
    }

    public ConcurrentTestSupport() {
        this(Duration.ofMinutes(1L));
    }

    @Override
    public void executeAndWait(@NonNull Collection<Runnable> runnables) {
        Objects.requireNonNull(runnables, "runnables must not be null");
        try {
            CompletableFuture.allOf((CompletableFuture[])runnables.stream().map(r -> CompletableFuture.runAsync(r, this.executorService)).toArray(CompletableFuture[]::new)).get(this.maxWaitTime.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e.getClass().getSimpleName() + " in submitAndWait", e);
        }
    }

    @Override
    public void executeAndWait(Runnable ... runnables) {
        this.executeAndWait(List.of(Objects.requireNonNull(runnables, "runnables must not be null")));
    }

    @Override
    @NonNull
    public <V> List<V> submitAndWait(@NonNull Collection<Callable<V>> callables) {
        Objects.requireNonNull(callables, "callables must not be null");
        AbstractCollection result = callables.size() > 1 ? new ConcurrentLinkedDeque() : new ArrayDeque();
        this.executeAndWait(ConcurrentTestSupport.callablesToRunners(callables, result));
        return List.copyOf(result);
    }

    @Override
    @SafeVarargs
    @NonNull
    public final <V> List<V> submitAndWait(Callable<V> ... callable) {
        Objects.requireNonNull(callable, "callable must not be null");
        return this.submitAndWait(List.of(callable));
    }

    @Override
    public void close() {
        this.executorService.close();
    }

    private static <V> Collection<Runnable> callablesToRunners(Collection<Callable<V>> callables, Collection<V> result) {
        return callables.stream().map(c -> ConcurrentTestSupport.toRunnable(c, result)).collect(Collectors.toList());
    }

    private static <V> Runnable toRunnable(Callable<V> callable, Collection<V> result) {
        return () -> {
            try {
                result.add(callable.call());
            }
            catch (Exception e) {
                throw new RuntimeException("Error in submitAndWait", e);
            }
        };
    }
}

