/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkle.test.fixtures.map.lifecycle;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkle.test.fixtures.map.lifecycle.ExpectedValue;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import com.swirlds.merkle.test.fixtures.map.serialization.MapKeyDeserializer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.Hash;

public class SaveExpectedMapHandler {
    private static final Logger logger = LogManager.getLogger(SaveExpectedMapHandler.class);
    private static final Marker MARKER = MarkerManager.getMarker((String)"SAVE_EXPECTED_MAP");
    public static final String STORAGE_DIRECTORY = "data/lifecycle";
    private static final String JSON_FILE_NAME_TEMPLATE = "Node%04d_ExpectedMap_%d_%d.json";
    private static final ObjectMapper objectMapper;
    private static final ObjectWriter objectWriter;

    public static String serialize(Map<MapKey, ExpectedValue> map, File directory, String fileName, boolean returnJsonString) {
        try {
            return SaveExpectedMapHandler.serializeThrowing(map, directory, fileName, returnJsonString);
        }
        catch (IOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Error occurred while serializing ExpectedMap", (Throwable)e);
            return "";
        }
    }

    public static String serializeThrowing(Map<MapKey, ExpectedValue> map, File directory, String fileName, boolean returnJsonString) throws IOException {
        String jsonZipFileName;
        File jsonZip;
        String jsonValue = "";
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if ((jsonZip = new File(directory, jsonZipFileName = String.format("%s.gz", fileName))).exists()) {
            jsonZip.delete();
        }
        logger.info(MARKER, "Serializing ExpectedMap {}", (Object)jsonZipFileName);
        try (FileOutputStream fos = new FileOutputStream(jsonZip);
             ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(fos));){
            zos.putNextEntry(new ZipEntry(fileName));
            if (returnJsonString) {
                jsonValue = objectWriter.writeValueAsString(map);
            }
            objectWriter.writeValue((OutputStream)zos, map);
            zos.flush();
            fos.flush();
        }
        return jsonValue;
    }

    public static Map<MapKey, ExpectedValue> deserialize(File sourceFile) throws IOException {
        ConcurrentHashMap<MapKey, ExpectedValue> newMap = new ConcurrentHashMap();
        SaveExpectedMapHandler.registerModule();
        File jsonFile = SaveExpectedMapHandler.unzipExpectedMap(sourceFile);
        if (jsonFile == null) {
            throw new IllegalArgumentException("No JSON file found in the zip file: %s".formatted(sourceFile));
        }
        try (FileInputStream fileInputStream = new FileInputStream(jsonFile);){
            newMap = (Map)objectMapper.readValue((InputStream)fileInputStream, (TypeReference)new TypeReference<Map<MapKey, ExpectedValue>>(){});
        }
        jsonFile.delete();
        return newMap;
    }

    public static String createExpectedMapName(long nodeId, Instant consensusTime) {
        return String.format(JSON_FILE_NAME_TEMPLATE, nodeId, consensusTime.toEpochMilli(), consensusTime.getNano());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File unzipExpectedMap(File sourceFile) {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(sourceFile));){
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory() && entry.getName().endsWith(".json") && !entry.getName().startsWith("__MACOSX")) {
                    File file = SaveExpectedMapHandler.extractFile(zis, sourceFile.getParentFile(), entry.getName());
                    return file;
                }
                zis.closeEntry();
                entry = zis.getNextEntry();
            }
            return null;
        }
        catch (IOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Error occurred while unzipping: {}", (Object)sourceFile, (Object)e);
        }
        return null;
    }

    private static File extractFile(ZipInputStream zis, File directory, String fileName) {
        File newFile = new File(directory, fileName);
        if (newFile.exists()) {
            newFile.delete();
        }
        byte[] buffer = new byte[1024];
        try (FileOutputStream fos = new FileOutputStream(newFile);){
            int len;
            while ((len = zis.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Error occurred while extracting file", (Throwable)e);
        }
        return newFile;
    }

    private static void registerModule() {
        SimpleModule mapKeyModule = new SimpleModule();
        mapKeyModule.addKeyDeserializer(MapKey.class, (KeyDeserializer)new MapKeyDeserializer());
        objectMapper.registerModule((Module)mapKeyModule);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    static {
        SimpleModule hashModule = new SimpleModule();
        hashModule.addSerializer(Hash.class, (JsonSerializer)new HashSerializer());
        hashModule.addDeserializer(Hash.class, (JsonDeserializer)new HashDeserializer());
        objectMapper = new ObjectMapper().registerModule((Module)hashModule).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectWriter = objectMapper.writer((PrettyPrinter)new DefaultPrettyPrinter());
    }

    public static class HashSerializer
    extends StdSerializer<Hash> {
        public HashSerializer() {
            super(Hash.class);
        }

        public void serialize(Hash value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("digestType", value.getDigestType().toString());
            gen.writeStringField("bytes", value.getBytes().toHex());
            gen.writeEndObject();
        }
    }

    public static class HashDeserializer
    extends StdDeserializer<Hash> {
        public HashDeserializer() {
            super(Hash.class);
        }

        public Hash deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            String digestString = node.get("digestType").asText();
            DigestType digestType = DigestType.valueOf((String)digestString);
            String hex = node.get("bytes").asText();
            return new Hash(Bytes.fromHex((String)hex), digestType);
        }
    }
}

