/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkle.map;

import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;

public final class MerkleMapMetrics {
    private static final String MM_CATEGORY = "MM";
    private static volatile boolean registered;
    private static final RunningAverageMetric.Config MMM_GET_MICRO_SEC_CONFIG;
    private static RunningAverageMetric mmmGetMicroSec;
    private static final RunningAverageMetric.Config MM_GFM_MICRO_SEC_CONFIG;
    private static RunningAverageMetric mmGfmMicroSec;
    private static final RunningAverageMetric.Config MM_REPLACE_MICRO_SEC_CONFIG;
    private static RunningAverageMetric mmReplaceMicroSec;
    private static final RunningAverageMetric.Config MM_PUT_MICRO_SEC_CONFIG;
    private static RunningAverageMetric mmPutMicroSec;

    private MerkleMapMetrics() {
    }

    public static boolean isRegistered() {
        return registered;
    }

    public static void register(Metrics metrics) {
        mmmGetMicroSec = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)MMM_GET_MICRO_SEC_CONFIG);
        mmGfmMicroSec = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)MM_GFM_MICRO_SEC_CONFIG);
        mmReplaceMicroSec = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)MM_REPLACE_MICRO_SEC_CONFIG);
        mmPutMicroSec = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)MM_PUT_MICRO_SEC_CONFIG);
        registered = true;
    }

    public static void updateMmmGetMicroSec(long microseconds) {
        mmmGetMicroSec.update((double)microseconds);
    }

    public static void updateMmGfmMicroSec(long microseconds) {
        mmGfmMicroSec.update((double)microseconds);
    }

    public static void updateMmReplaceMicroSec(long microseconds) {
        mmReplaceMicroSec.update((double)microseconds);
    }

    public static void updateMmPutMicroSec(long microseconds) {
        mmPutMicroSec.update((double)microseconds);
    }

    static {
        MMM_GET_MICRO_SEC_CONFIG = new RunningAverageMetric.Config(MM_CATEGORY, "mmGetMicroSec").withDescription("avg time taken to execute the MerkleMap get method (in microseconds)");
        MM_GFM_MICRO_SEC_CONFIG = new RunningAverageMetric.Config(MM_CATEGORY, "mmGfmMicroSec").withDescription("avg time taken to execute the MerkleMap getForModify method (in microseconds)");
        MM_REPLACE_MICRO_SEC_CONFIG = new RunningAverageMetric.Config(MM_CATEGORY, "mmReplaceMicroSec").withDescription("avg time taken to execute the MerkleMap replace method (in microseconds)");
        MM_PUT_MICRO_SEC_CONFIG = new RunningAverageMetric.Config(MM_CATEGORY, "mmPutMicroSec").withDescription("avg time taken to execute the MerkleMap put method (in microseconds)");
    }
}

