/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.merkle.dummy;

import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.impl.PartialMerkleLeaf;
import com.swirlds.common.test.fixtures.merkle.dummy.DummyMerkleNode;
import com.swirlds.common.test.fixtures.merkle.util.MerkleTestUtils;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.junit.jupiter.api.Assertions;

public class DummyMerkleExternalLeaf
extends PartialMerkleLeaf
implements DummyMerkleNode,
MerkleLeaf {
    private static final long CLASS_ID = 2255827092L;
    private static final int CLASS_VERSION = 1;
    protected long seed;
    protected int averageSize;
    protected int standardDeviation;
    private static final int MAX_VALUE_LENGTH = 1024;
    private AtomicBoolean destroyed = new AtomicBoolean(false);

    public DummyMerkleExternalLeaf(long seed, int averageSize, int standardDeviation) {
        this.seed = seed;
        this.averageSize = averageSize;
        this.standardDeviation = standardDeviation;
    }

    public DummyMerkleExternalLeaf() {
    }

    private DummyMerkleExternalLeaf(DummyMerkleExternalLeaf that) {
        super((PartialMerkleLeaf)that);
        this.seed = that.seed;
        this.averageSize = that.averageSize;
        this.standardDeviation = that.standardDeviation;
    }

    protected String generateValue() {
        String value = MerkleTestUtils.generateRandomString(this.seed, (double)this.averageSize, (double)this.standardDeviation);
        if (value.length() > 1024) {
            value = value.substring(0, 1024);
        }
        return value;
    }

    private Path getFile(Path directory) {
        return directory.resolve("DummyMerkleExternalLeaf-" + this.seed + "-" + this.averageSize + "-" + this.standardDeviation);
    }

    public void serialize(SerializableDataOutputStream out, Path outputDirectory) throws IOException {
        out.writeLong(this.seed);
        out.writeInt(this.averageSize);
        out.writeInt(this.standardDeviation);
        try (SerializableDataOutputStream fileOut = new SerializableDataOutputStream((OutputStream)new FileOutputStream(this.getFile(outputDirectory).toFile()));){
            fileOut.writeNormalisedString(this.generateValue());
        }
    }

    public void deserialize(SerializableDataInputStream in, Path inputDirectory, int version) throws IOException {
        this.seed = in.readLong();
        this.averageSize = in.readInt();
        this.standardDeviation = in.readInt();
        try (SerializableDataInputStream fileIn = new SerializableDataInputStream((InputStream)new FileInputStream(this.getFile(inputDirectory).toFile()));){
            Assertions.assertEquals((Object)this.generateValue(), (Object)fileIn.readNormalisedString(Integer.MAX_VALUE), (String)"deserialized value should match");
        }
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.seed);
        out.writeInt(this.averageSize);
        out.writeInt(this.standardDeviation);
        out.writeNormalisedString(this.generateValue());
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.seed = in.readLong();
        this.averageSize = in.readInt();
        this.standardDeviation = in.readInt();
        String v = in.readNormalisedString(1024);
        Assertions.assertEquals((Object)this.generateValue(), (Object)v, (String)"deserialized value should match");
    }

    public long getClassId() {
        return 2255827092L;
    }

    public int getVersion() {
        return 1;
    }

    @Override
    public String getValue() {
        return this.generateValue();
    }

    public String toString() {
        return "<" + this.seed + ", " + this.averageSize + ", " + this.standardDeviation + ">";
    }

    public void destroyNode() {
        if (!this.destroyed.compareAndSet(false, true)) {
            throw new IllegalStateException("This type of node should only be deleted once");
        }
    }

    public DummyMerkleExternalLeaf copy() {
        return new DummyMerkleExternalLeaf(this);
    }
}

