/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.statistics;

import com.swirlds.base.time.Time;
import com.swirlds.common.metrics.statistics.StatSettings;
import com.swirlds.common.metrics.statistics.StatSettingsFactory;
import com.swirlds.common.metrics.statistics.StatsBuffered;
import com.swirlds.common.metrics.statistics.internal.StatsBuffer;
import java.util.Objects;

@Deprecated(forRemoval=true)
public class StatsSpeedometer
implements StatsBuffered {
    private static final double LN_2 = Math.log(2.0);
    private final Time time;
    private long startTime;
    private long lastTime;
    private double cyclesPerSecond = 0.0;
    private double halfLife = 7.0;
    private StatsBuffer allHistory = null;
    private StatsBuffer recentHistory = null;

    @Override
    public StatsBuffer getAllHistory() {
        return this.allHistory;
    }

    @Override
    public StatsBuffer getRecentHistory() {
        return this.recentHistory;
    }

    public StatsSpeedometer(double halfLife) {
        this(halfLife, true);
    }

    public StatsSpeedometer(double halfLife, boolean saveHistory) {
        this(halfLife, saveHistory, Time.getCurrent());
    }

    @Deprecated(forRemoval=true)
    public StatsSpeedometer(double halfLife, Time time) {
        this(halfLife, true, time);
    }

    @Deprecated(forRemoval=true)
    public StatsSpeedometer(double halfLife, boolean saveHistory, Time time) {
        long now;
        this.time = Objects.requireNonNull(time, "time must not be null");
        this.startTime = now = time.nanoTime();
        this.lastTime = now;
        this.reset(halfLife, saveHistory);
    }

    @Override
    public void reset(double halfLife) {
        this.reset(halfLife, true);
    }

    private void reset(double halfLife, boolean saveHistory) {
        StatSettings settings = StatSettingsFactory.get();
        this.halfLife = Math.max(0.01, halfLife);
        this.lastTime = this.startTime = this.time.nanoTime();
        this.cyclesPerSecond = 0.0;
        if (saveHistory) {
            this.allHistory = new StatsBuffer(settings.getBufferSize(), 0.0, settings.getSkipSeconds(), this.time);
            this.recentHistory = new StatsBuffer(settings.getBufferSize(), settings.getRecentSeconds(), 0.0, this.time);
        } else {
            this.allHistory = null;
            this.recentHistory = null;
        }
    }

    public double getCyclesPerSecond() {
        return this.update(0.0, false);
    }

    public double cycle() {
        return this.update(1.0);
    }

    public synchronized double update(double numCycles) {
        return this.update(numCycles, true);
    }

    private synchronized double update(double numCycles, boolean recordData) {
        long currentTime = this.time.nanoTime();
        double t1 = (double)(this.lastTime - this.startTime) / 1.0E9;
        double t2 = (double)(currentTime - this.startTime) / 1.0E9;
        double dt = (double)(currentTime - this.lastTime) / 1.0E9;
        if (t2 >= 1.0E-9) {
            this.cyclesPerSecond = 1.0 / t2 > LN_2 / this.halfLife ? (this.cyclesPerSecond * t1 + numCycles) / t2 : this.cyclesPerSecond * Math.pow(0.5, dt / this.halfLife) + numCycles * LN_2 / this.halfLife;
        }
        this.lastTime = currentTime;
        if (this.allHistory != null && recordData) {
            this.allHistory.recordValue(this.cyclesPerSecond);
            this.recentHistory.recordValue(this.cyclesPerSecond);
        }
        return this.cyclesPerSecond;
    }

    @Override
    public double getMean() {
        return this.cyclesPerSecond;
    }

    @Override
    public double getMax() {
        if (this.allHistory.numBins() > 0) {
            return this.allHistory.yMaxMostRecent();
        }
        if (this.recentHistory.numBins() > 0) {
            return this.recentHistory.yMaxMostRecent();
        }
        return 0.0;
    }

    @Override
    public double getMin() {
        if (this.allHistory.numBins() > 0) {
            return this.allHistory.yMinMostRecent();
        }
        if (this.recentHistory.numBins() > 0) {
            return this.recentHistory.yMinMostRecent();
        }
        return 0.0;
    }

    @Override
    public double getStdDev() {
        if (this.allHistory.numBins() > 0) {
            return this.allHistory.yStdMostRecent();
        }
        if (this.recentHistory.numBins() > 0) {
            return this.recentHistory.yStdMostRecent();
        }
        return 0.0;
    }
}

