/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkle.map;

import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.copy.MerklePathReplacement;
import com.swirlds.common.merkle.impl.PartialBinaryMerkleInternal;
import com.swirlds.common.merkle.iterators.MerkleIterator;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.common.merkle.utility.DebugIterationEndpoint;
import com.swirlds.common.merkle.utility.Keyed;
import com.swirlds.common.merkle.utility.MerkleUtils;
import com.swirlds.common.utility.Labeled;
import com.swirlds.common.utility.RuntimeObjectRecord;
import com.swirlds.common.utility.RuntimeObjectRegistry;
import com.swirlds.common.utility.StopWatch;
import com.swirlds.fchashmap.FCHashMap;
import com.swirlds.fchashmap.ModifiableValue;
import com.swirlds.merkle.map.MerkleMapMetrics;
import com.swirlds.merkle.map.internal.MerkleMapEntrySet;
import com.swirlds.merkle.map.internal.MerkleMapInfo;
import com.swirlds.merkle.tree.MerkleBinaryTree;
import com.swirlds.merkle.tree.MerkleTreeInternalNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;
import org.hiero.base.crypto.Hash;

@DebugIterationEndpoint
@Deprecated
public class MerkleMap<K, V extends MerkleNode & Keyed<K>>
extends PartialBinaryMerkleInternal
implements Labeled,
Map<K, V>,
MerkleInternal {
    public static final long CLASS_ID = -7776220400278906634L;
    private static final int DEFAULT_INITIAL_MAP_CAPACITY = 2000000;
    protected FCHashMap<K, V> index;
    private final StampedLock lock;
    private final RuntimeObjectRecord registryRecord;
    private static final boolean LOCKS_DISABLED_FOR_DEBUGGING = false;

    public MerkleMap() {
        this(2000000);
    }

    public MerkleMap(int initialCapacity) {
        this.index = new FCHashMap(initialCapacity);
        this.setTree(new MerkleBinaryTree());
        this.setInfo(new MerkleMapInfo());
        this.setImmutable(false);
        this.lock = new StampedLock();
        this.registryRecord = RuntimeObjectRegistry.createRecord(this.getClass());
    }

    private MerkleMap(MerkleMap<K, V> that) {
        super(that);
        this.setTree((MerkleBinaryTree<V>)that.getTree().copy());
        if (that.getInfo() != null) {
            this.setInfo(that.getInfo().copy());
        } else {
            this.setInfo(new MerkleMapInfo());
        }
        this.index = that.index.copy();
        this.lock = new StampedLock();
        this.setImmutable(false);
        that.setImmutable(true);
        this.registryRecord = RuntimeObjectRegistry.createRecord(this.getClass());
    }

    private long readLock() {
        return this.lock.readLock();
    }

    private void releaseReadLock(long stamp) {
        this.lock.unlockRead(stamp);
    }

    private long writeLock() {
        return this.lock.writeLock();
    }

    private void releaseWriteLock(long stamp) {
        this.lock.unlockWrite(stamp);
    }

    public boolean childHasExpectedType(int index, long childClassId) {
        if (index == 0) {
            return childClassId == -8881449756281471252L;
        }
        return true;
    }

    private MerkleBinaryTree<V> getTree() {
        return (MerkleBinaryTree)this.getChild(0);
    }

    private void setTree(MerkleBinaryTree<V> tree) {
        this.setChild(0, (MerkleNode)tree);
    }

    private MerkleMapInfo getInfo() {
        return (MerkleMapInfo)this.getChild(1);
    }

    private void setInfo(MerkleMapInfo info) {
        this.setChild(1, (MerkleNode)info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        long stamp = this.readLock();
        try {
            long l = this.getTree().size();
            return l;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    public void addDeserializedChildren(List<MerkleNode> children, int version) {
        if (children.size() == 1) {
            if (version == 1) {
                children.add((MerkleNode)new MerkleMapInfo());
            } else {
                throw new IllegalArgumentException("Missing MerkleMapInfo child");
            }
        }
        super.addDeserializedChildren(children, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MerkleMap<K, V> copy() {
        this.throwIfImmutable();
        this.throwIfDestroyed();
        long stamp = this.readLock();
        try {
            MerkleMap<K, V> merkleMap = new MerkleMap<K, V>(this);
            return merkleMap;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    private void updateCache(V entry) {
        this.index.put(((Keyed)entry).getKey(), entry);
    }

    protected synchronized void destroyNode() {
        this.registryRecord.release();
        this.index.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        this.throwIfImmutable();
        long stamp = this.writeLock();
        try {
            MerkleNode entry = (MerkleNode)this.index.remove(key);
            if (entry == null) {
                V v = null;
                return v;
            }
            this.getTree().delete(entry, x$0 -> this.updateCache((MerkleNode)x$0));
            this.invalidateHash();
            MerkleNode merkleNode = entry;
            return (V)merkleNode;
        }
        finally {
            this.releaseWriteLock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        StopWatch watch = null;
        if (MerkleMapMetrics.isRegistered()) {
            watch = new StopWatch();
            watch.start();
        }
        long stamp = this.readLock();
        try {
            MerkleNode entry = this.index.isDestroyed() ? this.getTree().findValue(v -> Objects.equals(key, ((Keyed)v).getKey())) : (MerkleNode)this.index.get(key);
            MerkleNode merkleNode = entry;
            return (V)merkleNode;
        }
        finally {
            this.releaseReadLock(stamp);
            if (watch != null) {
                watch.stop();
                MerkleMapMetrics.updateMmmGetMicroSec(watch.getTime(TimeUnit.MICROSECONDS));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getForModify(K key) {
        this.throwIfImmutable();
        StopWatch watch = null;
        if (MerkleMapMetrics.isRegistered()) {
            watch = new StopWatch();
            watch.start();
        }
        long stamp = this.readLock();
        try {
            ModifiableValue value = this.index.getForModify(key);
            if (value == null) {
                V v = null;
                return v;
            }
            MerkleNode copy = (MerkleNode)value.value();
            MerkleNode original = (MerkleNode)value.original();
            MerkleRoute route = original.getRoute();
            if (copy != original) {
                MerkleNode[] path = MerklePathReplacement.replacePath(this.getTree(), (MerkleRoute)route, (int)1);
                MerkleTreeInternalNode parent = (MerkleTreeInternalNode)MerklePathReplacement.getParentInPath((MerkleNode[])path);
                int indexInParent = MerkleUtils.findChildPositionInParent((MerkleInternal)parent, (MerkleNode)original);
                parent.setChild(indexInParent, copy, route, false);
                this.getTree().registerCopy(original, copy);
            }
            MerkleNode merkleNode = copy;
            return (V)merkleNode;
        }
        finally {
            this.releaseReadLock(stamp);
            if (watch != null) {
                watch.stop();
                MerkleMapMetrics.updateMmGfmMicroSec(watch.getTime(TimeUnit.MICROSECONDS));
            }
        }
    }

    @Override
    public V put(K key, V value) {
        this.throwIfImmutable();
        if (key == null) {
            throw new NullPointerException("null keys are not supported");
        }
        if (value == null) {
            throw new NullPointerException("null values are not supported");
        }
        StopWatch watch = null;
        if (MerkleMapMetrics.isRegistered()) {
            watch = new StopWatch();
            watch.start();
        }
        V val = this.putInternal(key, value);
        if (watch != null) {
            watch.stop();
            MerkleMapMetrics.updateMmPutMicroSec(watch.getTime(TimeUnit.MICROSECONDS));
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V putInternal(K key, V value) {
        long stamp = this.writeLock();
        try {
            if (this.index.containsKey(key)) {
                V v = this.replaceInternal(key, value);
                return v;
            }
            if (value.getReservationCount() != 0) {
                throw new IllegalArgumentException("Value is in another tree, can not insert");
            }
            ((Keyed)value).setKey(key);
            this.getTree().insert(value, x$0 -> this.updateCache((MerkleNode)x$0));
            this.index.put(key, value);
            this.invalidateHash();
            V v = null;
            return v;
        }
        finally {
            this.releaseWriteLock(stamp);
        }
    }

    @Override
    public int size() {
        return (int)this.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        long stamp = this.readLock();
        try {
            boolean bl = this.index.containsKey(key);
            return bl;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        long stamp = this.readLock();
        try {
            boolean bl = this.getTree().isEmpty();
            return bl;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    private V replaceInternal(K key, V value) {
        MerkleNode oldEntry = (MerkleNode)this.index.get(key);
        if (oldEntry == null) {
            throw new IllegalStateException("Can not replace value that is not in the map");
        }
        if (oldEntry == value) {
            return value;
        }
        if (value.getReservationCount() != 0) {
            throw new IllegalArgumentException("Value is already in a tree, can not insert into map");
        }
        this.invalidateHash();
        this.getTree().invalidateHash();
        this.getTree().getRoot().invalidateHash();
        ((Keyed)value).setKey(key);
        this.getTree().update(oldEntry, value);
        this.index.put(key, value);
        return (V)oldEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        this.throwIfImmutable();
        if (key == null) {
            throw new NullPointerException("null keys are not supported");
        }
        if (value == null) {
            throw new NullPointerException("null values are not supported");
        }
        StopWatch watch = null;
        if (MerkleMapMetrics.isRegistered()) {
            watch = new StopWatch();
            watch.start();
        }
        long stamp = this.writeLock();
        try {
            V v = this.replaceInternal(key, value);
            return v;
        }
        finally {
            this.releaseWriteLock(stamp);
            if (watch != null) {
                watch.stop();
                MerkleMapMetrics.updateMmReplaceMicroSec(watch.getTime(TimeUnit.MICROSECONDS));
            }
        }
    }

    @Override
    public void clear() {
        this.throwIfImmutable();
        long stamp = this.writeLock();
        try {
            this.index.clear();
            this.getTree().clear();
            this.invalidateHash();
        }
        finally {
            this.releaseWriteLock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        long stamp = this.readLock();
        try {
            MerkleIterator<V> entryIterator = this.getTree().iterator();
            HashSet<Object> keys = new HashSet<Object>();
            while (entryIterator.hasNext()) {
                MerkleNode entry = (MerkleNode)entryIterator.next();
                keys.add(((Keyed)entry).getKey());
            }
            HashSet<Object> hashSet = keys;
            return hashSet;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        long stamp = this.readLock();
        try {
            MerkleIterator<V> entryIterator = this.getTree().iterator();
            HashSet<MerkleNode> values = new HashSet<MerkleNode>();
            while (entryIterator.hasNext()) {
                values.add((MerkleNode)entryIterator.next());
            }
            HashSet<MerkleNode> hashSet = values;
            return hashSet;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        long stamp = this.readLock();
        try {
            MerkleMapEntrySet merkleMapEntrySet = new MerkleMapEntrySet(this);
            return merkleMapEntrySet;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        long stamp = this.readLock();
        try {
            boolean bl = this.values().stream().anyMatch(v -> Objects.equals(v, value));
            return bl;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), (V)((MerkleNode)entry.getValue()));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MerkleMap)) {
            return false;
        }
        MerkleMap merkleMap = (MerkleMap)o;
        Hash rootHash = this.getRootHash();
        Hash otherRootHash = merkleMap.getRootHash();
        return rootHash.equals((Object)otherRootHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        long stamp = this.readLock();
        try {
            Hash hash = this.getTree().getHash();
            if (hash == null) {
                int n = super.hashCode();
                return n;
            }
            int n = hash.hashCode();
            return n;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hash getRootHash() {
        long stamp = this.readLock();
        try {
            Hash hash = this.getTree().getHash();
            return hash;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    public String toString() {
        return String.format("Size: %d - %s", this.getTree().size(), this.getRootHash());
    }

    public FCHashMap<K, V> getIndex() {
        return this.index;
    }

    public long getClassId() {
        return -7776220400278906634L;
    }

    public String getLabel() {
        return this.getInfo().getLabel();
    }

    public void setLabel(String label) {
        this.getInfo().setLabel(label);
    }

    public int getVersion() {
        return 2;
    }

    private void rebuildSubtree(MerkleNode subtreeRoot) {
        subtreeRoot.treeIterator().setFilter(node -> node.getClassId() != 1953444780092841751L).setDescendantFilter(node -> node.getClassId() == 1953444780092841751L).forEachRemaining(node -> {
            MerkleNode entry = node;
            this.index.initialInjection(((Keyed)entry).getKey(), (Object)entry);
        });
    }

    public void rebuild() {
        int splitDepth = 7 + this.getTree().getRoot().getDepth();
        LinkedList internalNodes = new LinkedList();
        LinkedList entries = new LinkedList();
        this.getTree().getRoot().treeIterator().setFilter(node -> node.getDepth() <= splitDepth).setDescendantFilter(node -> node.getDepth() < splitDepth && node.getClassId() == 1953444780092841751L).forEachRemaining(node -> {
            if (node.getClassId() == 1953444780092841751L) {
                if (node.getDepth() == splitDepth) {
                    internalNodes.add(node);
                }
            } else {
                entries.add(node);
            }
        });
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            MerkleNode node2;
            MerkleNode entry = node2 = (MerkleNode)iterator.next();
            this.index.initialInjection(((Keyed)entry).getKey(), (Object)entry);
        }
        if (!internalNodes.isEmpty()) {
            ArrayList futures = new ArrayList(internalNodes.size());
            ForkJoinPool executor = new ForkJoinPool(24);
            for (MerkleNode merkleNode : internalNodes) {
                futures.add(executor.submit(() -> this.rebuildSubtree(subtreeRoot)));
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("interrupted while attempting to rebuild MerkleMap, this is unrecoverable");
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            executor.shutdown();
        }
        this.index.initialResize();
    }

    private static class ChildIndices {
        public static final int TREE = 0;
        public static final int INFO = 1;

        private ChildIndices() {
        }
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;
        public static final int ADDED_INFO_LEAF = 2;

        private ClassVersion() {
        }
    }
}

