/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.test.fixtures.merkle;

import com.hedera.hapi.node.base.SemanticVersion;
import com.swirlds.state.lifecycle.StateMetadata;
import edu.umd.cs.findbugs.annotations.NonNull;

public class StateClassIdUtils {
    private static final String ON_DISK_KEY_CLASS_ID_SUFFIX = "OnDiskKey";
    private static final String ON_DISK_KEY_SERIALIZER_CLASS_ID_SUFFIX = "OnDiskKeySerializer";
    private static final String ON_DISK_VALUE_CLASS_ID_SUFFIX = "OnDiskValue";
    private static final String ON_DISK_VALUE_SERIALIZER_CLASS_ID_SUFFIX = "OnDiskValueSerializer";
    private static final String IN_MEMORY_VALUE_CLASS_ID_SUFFIX = "InMemoryValue";
    private static final String SINGLETON_CLASS_ID_SUFFIX = "SingletonLeaf";
    private static final String QUEUE_NODE_CLASS_ID_SUFFIX = "QueueNode";

    public static long onDiskKeyClassId(String serviceName, String stateKey, SemanticVersion version) {
        return StateClassIdUtils.computeClassId(serviceName, stateKey, version, ON_DISK_KEY_CLASS_ID_SUFFIX);
    }

    public static long onDiskKeySerializerClassId(String serviceName, String stateKey, SemanticVersion version) {
        return StateClassIdUtils.computeClassId(serviceName, stateKey, version, ON_DISK_KEY_SERIALIZER_CLASS_ID_SUFFIX);
    }

    public static long onDiskValueClassId(String serviceName, String stateKey, SemanticVersion version) {
        return StateClassIdUtils.computeClassId(serviceName, stateKey, version, ON_DISK_VALUE_CLASS_ID_SUFFIX);
    }

    public static long onDiskValueSerializerClassId(String serviceName, String stateKey, SemanticVersion version) {
        return StateClassIdUtils.computeClassId(serviceName, stateKey, version, ON_DISK_VALUE_SERIALIZER_CLASS_ID_SUFFIX);
    }

    public static long inMemoryValueClassId(String serviceName, String stateKey, SemanticVersion version) {
        return StateClassIdUtils.computeClassId(serviceName, stateKey, version, IN_MEMORY_VALUE_CLASS_ID_SUFFIX);
    }

    public static long singletonClassId(String serviceName, String stateKey, SemanticVersion version) {
        return StateClassIdUtils.computeClassId(serviceName, stateKey, version, SINGLETON_CLASS_ID_SUFFIX);
    }

    public static long queueNodeClassId(String serviceName, String stateKey, SemanticVersion version) {
        return StateClassIdUtils.computeClassId(serviceName, stateKey, version, QUEUE_NODE_CLASS_ID_SUFFIX);
    }

    public static long computeClassId(@NonNull String serviceName, @NonNull String stateKey, @NonNull SemanticVersion version, @NonNull String extra) {
        String ver = "v" + version.major() + "." + version.minor() + "." + version.patch();
        return StateMetadata.hashString((String)(serviceName + ":" + stateKey + ":" + ver + ":" + extra));
    }
}

