/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.base.Fraction;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.transaction.NodeStake;
import com.hedera.hapi.node.transaction.codec.NodeStakeUpdateTransactionBodyJsonCodec;
import com.hedera.hapi.node.transaction.codec.NodeStakeUpdateTransactionBodyProtoCodec;
import com.hedera.hapi.node.transaction.schema.NodeStakeUpdateTransactionBodySchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class NodeStakeUpdateTransactionBody {
    public static final Codec<NodeStakeUpdateTransactionBody> PROTOBUF = new NodeStakeUpdateTransactionBodyProtoCodec();
    public static final JsonCodec<NodeStakeUpdateTransactionBody> JSON = new NodeStakeUpdateTransactionBodyJsonCodec();
    public static final NodeStakeUpdateTransactionBody DEFAULT = NodeStakeUpdateTransactionBody.newBuilder().build();
    @Nullable
    private final Timestamp endOfStakingPeriod;
    @NonNull
    private final List<NodeStake> nodeStake;
    private final long maxStakingRewardRatePerHbar;
    @Nullable
    private final Fraction nodeRewardFeeFraction;
    private final long stakingPeriodsStored;
    private final long stakingPeriod;
    @Nullable
    private final Fraction stakingRewardFeeFraction;
    private final long stakingStartThreshold;
    private final long stakingRewardRate;
    private final long reservedStakingRewards;
    private final long unreservedStakingRewardBalance;
    private final long rewardBalanceThreshold;
    private final long maxStakeRewarded;
    private final long maxTotalReward;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public NodeStakeUpdateTransactionBody(Timestamp endOfStakingPeriod, List<NodeStake> nodeStake, long maxStakingRewardRatePerHbar, Fraction nodeRewardFeeFraction, long stakingPeriodsStored, long stakingPeriod, Fraction stakingRewardFeeFraction, long stakingStartThreshold, long stakingRewardRate, long reservedStakingRewards, long unreservedStakingRewardBalance, long rewardBalanceThreshold, long maxStakeRewarded, long maxTotalReward) {
        this.$unknownFields = null;
        this.endOfStakingPeriod = endOfStakingPeriod;
        this.nodeStake = nodeStake == null ? Collections.emptyList() : nodeStake;
        this.maxStakingRewardRatePerHbar = maxStakingRewardRatePerHbar;
        this.nodeRewardFeeFraction = nodeRewardFeeFraction;
        this.stakingPeriodsStored = stakingPeriodsStored;
        this.stakingPeriod = stakingPeriod;
        this.stakingRewardFeeFraction = stakingRewardFeeFraction;
        this.stakingStartThreshold = stakingStartThreshold;
        this.stakingRewardRate = stakingRewardRate;
        this.reservedStakingRewards = reservedStakingRewards;
        this.unreservedStakingRewardBalance = unreservedStakingRewardBalance;
        this.rewardBalanceThreshold = rewardBalanceThreshold;
        this.maxStakeRewarded = maxStakeRewarded;
        this.maxTotalReward = maxTotalReward;
    }

    public NodeStakeUpdateTransactionBody(Timestamp endOfStakingPeriod, List<NodeStake> nodeStake, long maxStakingRewardRatePerHbar, Fraction nodeRewardFeeFraction, long stakingPeriodsStored, long stakingPeriod, Fraction stakingRewardFeeFraction, long stakingStartThreshold, long stakingRewardRate, long reservedStakingRewards, long unreservedStakingRewardBalance, long rewardBalanceThreshold, long maxStakeRewarded, long maxTotalReward, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.endOfStakingPeriod = endOfStakingPeriod;
        this.nodeStake = nodeStake == null ? Collections.emptyList() : nodeStake;
        this.maxStakingRewardRatePerHbar = maxStakingRewardRatePerHbar;
        this.nodeRewardFeeFraction = nodeRewardFeeFraction;
        this.stakingPeriodsStored = stakingPeriodsStored;
        this.stakingPeriod = stakingPeriod;
        this.stakingRewardFeeFraction = stakingRewardFeeFraction;
        this.stakingStartThreshold = stakingStartThreshold;
        this.stakingRewardRate = stakingRewardRate;
        this.reservedStakingRewards = reservedStakingRewards;
        this.unreservedStakingRewardBalance = unreservedStakingRewardBalance;
        this.rewardBalanceThreshold = rewardBalanceThreshold;
        this.maxStakeRewarded = maxStakeRewarded;
        this.maxTotalReward = maxTotalReward;
    }

    public Timestamp endOfStakingPeriod() {
        return this.endOfStakingPeriod;
    }

    public List<NodeStake> nodeStake() {
        return this.nodeStake;
    }

    public long maxStakingRewardRatePerHbar() {
        return this.maxStakingRewardRatePerHbar;
    }

    public Fraction nodeRewardFeeFraction() {
        return this.nodeRewardFeeFraction;
    }

    public long stakingPeriodsStored() {
        return this.stakingPeriodsStored;
    }

    public long stakingPeriod() {
        return this.stakingPeriod;
    }

    public Fraction stakingRewardFeeFraction() {
        return this.stakingRewardFeeFraction;
    }

    public long stakingStartThreshold() {
        return this.stakingStartThreshold;
    }

    public long stakingRewardRate() {
        return this.stakingRewardRate;
    }

    public long reservedStakingRewards() {
        return this.reservedStakingRewards;
    }

    public long unreservedStakingRewardBalance() {
        return this.unreservedStakingRewardBalance;
    }

    public long rewardBalanceThreshold() {
        return this.rewardBalanceThreshold;
    }

    public long maxStakeRewarded() {
        return this.maxStakeRewarded;
    }

    public long maxTotalReward() {
        return this.maxTotalReward;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NodeStakeUpdateTransactionBodySchema.END_OF_STAKING_PERIOD, (Object)this.endOfStakingPeriod, Timestamp.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)NodeStakeUpdateTransactionBodySchema.NODE_STAKE, this.nodeStake, NodeStake.PROTOBUF);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeUpdateTransactionBodySchema.MAX_STAKING_REWARD_RATE_PER_HBAR, (long)this.maxStakingRewardRatePerHbar, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NodeStakeUpdateTransactionBodySchema.NODE_REWARD_FEE_FRACTION, (Object)this.nodeRewardFeeFraction, Fraction.PROTOBUF);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeUpdateTransactionBodySchema.STAKING_PERIODS_STORED, (long)this.stakingPeriodsStored, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeUpdateTransactionBodySchema.STAKING_PERIOD, (long)this.stakingPeriod, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NodeStakeUpdateTransactionBodySchema.STAKING_REWARD_FEE_FRACTION, (Object)this.stakingRewardFeeFraction, Fraction.PROTOBUF);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeUpdateTransactionBodySchema.STAKING_START_THRESHOLD, (long)this.stakingStartThreshold, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeUpdateTransactionBodySchema.STAKING_REWARD_RATE, (long)this.stakingRewardRate, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeUpdateTransactionBodySchema.RESERVED_STAKING_REWARDS, (long)this.reservedStakingRewards, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeUpdateTransactionBodySchema.UNRESERVED_STAKING_REWARD_BALANCE, (long)this.unreservedStakingRewardBalance, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeUpdateTransactionBodySchema.REWARD_BALANCE_THRESHOLD, (long)this.rewardBalanceThreshold, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeUpdateTransactionBodySchema.MAX_STAKE_REWARDED, (long)this.maxStakeRewarded, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeUpdateTransactionBodySchema.MAX_TOTAL_REWARD, (long)this.maxTotalReward, (boolean)true);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            List<NodeStake> list$nodeStake;
            int result = 1;
            if (this.endOfStakingPeriod != null && !this.endOfStakingPeriod.equals(NodeStakeUpdateTransactionBody.DEFAULT.endOfStakingPeriod)) {
                result = 31 * result + this.endOfStakingPeriod.hashCode();
            }
            if ((list$nodeStake = this.nodeStake) != null) {
                for (NodeStake o : list$nodeStake) {
                    if (o != null) {
                        result = 31 * result + ((Object)o).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.maxStakingRewardRatePerHbar != NodeStakeUpdateTransactionBody.DEFAULT.maxStakingRewardRatePerHbar) {
                result = 31 * result + Long.hashCode(this.maxStakingRewardRatePerHbar);
            }
            if (this.nodeRewardFeeFraction != null && !this.nodeRewardFeeFraction.equals(NodeStakeUpdateTransactionBody.DEFAULT.nodeRewardFeeFraction)) {
                result = 31 * result + this.nodeRewardFeeFraction.hashCode();
            }
            if (this.stakingPeriodsStored != NodeStakeUpdateTransactionBody.DEFAULT.stakingPeriodsStored) {
                result = 31 * result + Long.hashCode(this.stakingPeriodsStored);
            }
            if (this.stakingPeriod != NodeStakeUpdateTransactionBody.DEFAULT.stakingPeriod) {
                result = 31 * result + Long.hashCode(this.stakingPeriod);
            }
            if (this.stakingRewardFeeFraction != null && !this.stakingRewardFeeFraction.equals(NodeStakeUpdateTransactionBody.DEFAULT.stakingRewardFeeFraction)) {
                result = 31 * result + this.stakingRewardFeeFraction.hashCode();
            }
            if (this.stakingStartThreshold != NodeStakeUpdateTransactionBody.DEFAULT.stakingStartThreshold) {
                result = 31 * result + Long.hashCode(this.stakingStartThreshold);
            }
            if (this.stakingRewardRate != NodeStakeUpdateTransactionBody.DEFAULT.stakingRewardRate) {
                result = 31 * result + Long.hashCode(this.stakingRewardRate);
            }
            if (this.reservedStakingRewards != NodeStakeUpdateTransactionBody.DEFAULT.reservedStakingRewards) {
                result = 31 * result + Long.hashCode(this.reservedStakingRewards);
            }
            if (this.unreservedStakingRewardBalance != NodeStakeUpdateTransactionBody.DEFAULT.unreservedStakingRewardBalance) {
                result = 31 * result + Long.hashCode(this.unreservedStakingRewardBalance);
            }
            if (this.rewardBalanceThreshold != NodeStakeUpdateTransactionBody.DEFAULT.rewardBalanceThreshold) {
                result = 31 * result + Long.hashCode(this.rewardBalanceThreshold);
            }
            if (this.maxStakeRewarded != NodeStakeUpdateTransactionBody.DEFAULT.maxStakeRewarded) {
                result = 31 * result + Long.hashCode(this.maxStakeRewarded);
            }
            if (this.maxTotalReward != NodeStakeUpdateTransactionBody.DEFAULT.maxTotalReward) {
                result = 31 * result + Long.hashCode(this.maxTotalReward);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        NodeStakeUpdateTransactionBody thatObj = (NodeStakeUpdateTransactionBody)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.endOfStakingPeriod == null && thatObj.endOfStakingPeriod != null) {
            return false;
        }
        if (this.endOfStakingPeriod != null && !this.endOfStakingPeriod.equals(thatObj.endOfStakingPeriod)) {
            return false;
        }
        if (this.nodeStake == null && thatObj.nodeStake != null) {
            return false;
        }
        if (this.nodeStake != null && !this.nodeStake.equals(thatObj.nodeStake)) {
            return false;
        }
        if (this.maxStakingRewardRatePerHbar != thatObj.maxStakingRewardRatePerHbar) {
            return false;
        }
        if (this.nodeRewardFeeFraction == null && thatObj.nodeRewardFeeFraction != null) {
            return false;
        }
        if (this.nodeRewardFeeFraction != null && !this.nodeRewardFeeFraction.equals(thatObj.nodeRewardFeeFraction)) {
            return false;
        }
        if (this.stakingPeriodsStored != thatObj.stakingPeriodsStored) {
            return false;
        }
        if (this.stakingPeriod != thatObj.stakingPeriod) {
            return false;
        }
        if (this.stakingRewardFeeFraction == null && thatObj.stakingRewardFeeFraction != null) {
            return false;
        }
        if (this.stakingRewardFeeFraction != null && !this.stakingRewardFeeFraction.equals(thatObj.stakingRewardFeeFraction)) {
            return false;
        }
        if (this.stakingStartThreshold != thatObj.stakingStartThreshold) {
            return false;
        }
        if (this.stakingRewardRate != thatObj.stakingRewardRate) {
            return false;
        }
        if (this.reservedStakingRewards != thatObj.reservedStakingRewards) {
            return false;
        }
        if (this.unreservedStakingRewardBalance != thatObj.unreservedStakingRewardBalance) {
            return false;
        }
        if (this.rewardBalanceThreshold != thatObj.rewardBalanceThreshold) {
            return false;
        }
        if (this.maxStakeRewarded != thatObj.maxStakeRewarded) {
            return false;
        }
        if (this.maxTotalReward != thatObj.maxTotalReward) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "NodeStakeUpdateTransactionBody[endOfStakingPeriod=" + String.valueOf(this.endOfStakingPeriod) + ", nodeStake=" + String.valueOf(this.nodeStake) + ", maxStakingRewardRatePerHbar=" + this.maxStakingRewardRatePerHbar + ", nodeRewardFeeFraction=" + String.valueOf(this.nodeRewardFeeFraction) + ", stakingPeriodsStored=" + this.stakingPeriodsStored + ", stakingPeriod=" + this.stakingPeriod + ", stakingRewardFeeFraction=" + String.valueOf(this.stakingRewardFeeFraction) + ", stakingStartThreshold=" + this.stakingStartThreshold + ", stakingRewardRate=" + this.stakingRewardRate + ", reservedStakingRewards=" + this.reservedStakingRewards + ", unreservedStakingRewardBalance=" + this.unreservedStakingRewardBalance + ", rewardBalanceThreshold=" + this.rewardBalanceThreshold + ", maxStakeRewarded=" + this.maxStakeRewarded + ", maxTotalReward=" + this.maxTotalReward + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasEndOfStakingPeriod() {
        return this.endOfStakingPeriod != null;
    }

    public Timestamp endOfStakingPeriodOrElse(@NonNull Timestamp defaultValue) {
        return this.hasEndOfStakingPeriod() ? this.endOfStakingPeriod : defaultValue;
    }

    @NonNull
    public Timestamp endOfStakingPeriodOrThrow() {
        return Objects.requireNonNull(this.endOfStakingPeriod, "Field endOfStakingPeriod is null");
    }

    public void ifEndOfStakingPeriod(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasEndOfStakingPeriod()) {
            ifPresent.accept(this.endOfStakingPeriod);
        }
    }

    public boolean hasNodeRewardFeeFraction() {
        return this.nodeRewardFeeFraction != null;
    }

    public Fraction nodeRewardFeeFractionOrElse(@NonNull Fraction defaultValue) {
        return this.hasNodeRewardFeeFraction() ? this.nodeRewardFeeFraction : defaultValue;
    }

    @NonNull
    public Fraction nodeRewardFeeFractionOrThrow() {
        return Objects.requireNonNull(this.nodeRewardFeeFraction, "Field nodeRewardFeeFraction is null");
    }

    public void ifNodeRewardFeeFraction(@NonNull Consumer<Fraction> ifPresent) {
        if (this.hasNodeRewardFeeFraction()) {
            ifPresent.accept(this.nodeRewardFeeFraction);
        }
    }

    public boolean hasStakingRewardFeeFraction() {
        return this.stakingRewardFeeFraction != null;
    }

    public Fraction stakingRewardFeeFractionOrElse(@NonNull Fraction defaultValue) {
        return this.hasStakingRewardFeeFraction() ? this.stakingRewardFeeFraction : defaultValue;
    }

    @NonNull
    public Fraction stakingRewardFeeFractionOrThrow() {
        return Objects.requireNonNull(this.stakingRewardFeeFraction, "Field stakingRewardFeeFraction is null");
    }

    public void ifStakingRewardFeeFraction(@NonNull Consumer<Fraction> ifPresent) {
        if (this.hasStakingRewardFeeFraction()) {
            ifPresent.accept(this.stakingRewardFeeFraction);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.endOfStakingPeriod, this.nodeStake, this.maxStakingRewardRatePerHbar, this.nodeRewardFeeFraction, this.stakingPeriodsStored, this.stakingPeriod, this.stakingRewardFeeFraction, this.stakingStartThreshold, this.stakingRewardRate, this.reservedStakingRewards, this.unreservedStakingRewardBalance, this.rewardBalanceThreshold, this.maxStakeRewarded, this.maxTotalReward, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private Timestamp endOfStakingPeriod = null;
        @NonNull
        private List<NodeStake> nodeStake = Collections.emptyList();
        private long maxStakingRewardRatePerHbar = 0L;
        @Nullable
        private Fraction nodeRewardFeeFraction = null;
        private long stakingPeriodsStored = 0L;
        private long stakingPeriod = 0L;
        @Nullable
        private Fraction stakingRewardFeeFraction = null;
        private long stakingStartThreshold = 0L;
        private long stakingRewardRate = 0L;
        private long reservedStakingRewards = 0L;
        private long unreservedStakingRewardBalance = 0L;
        private long rewardBalanceThreshold = 0L;
        private long maxStakeRewarded = 0L;
        private long maxTotalReward = 0L;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(Timestamp endOfStakingPeriod, List<NodeStake> nodeStake, long maxStakingRewardRatePerHbar, Fraction nodeRewardFeeFraction, long stakingPeriodsStored, long stakingPeriod, Fraction stakingRewardFeeFraction, long stakingStartThreshold, long stakingRewardRate, long reservedStakingRewards, long unreservedStakingRewardBalance, long rewardBalanceThreshold, long maxStakeRewarded, long maxTotalReward) {
            this.$unknownFields = null;
            this.endOfStakingPeriod = endOfStakingPeriod;
            this.nodeStake = nodeStake == null ? Collections.emptyList() : nodeStake;
            this.maxStakingRewardRatePerHbar = maxStakingRewardRatePerHbar;
            this.nodeRewardFeeFraction = nodeRewardFeeFraction;
            this.stakingPeriodsStored = stakingPeriodsStored;
            this.stakingPeriod = stakingPeriod;
            this.stakingRewardFeeFraction = stakingRewardFeeFraction;
            this.stakingStartThreshold = stakingStartThreshold;
            this.stakingRewardRate = stakingRewardRate;
            this.reservedStakingRewards = reservedStakingRewards;
            this.unreservedStakingRewardBalance = unreservedStakingRewardBalance;
            this.rewardBalanceThreshold = rewardBalanceThreshold;
            this.maxStakeRewarded = maxStakeRewarded;
            this.maxTotalReward = maxTotalReward;
        }

        public Builder(Timestamp endOfStakingPeriod, List<NodeStake> nodeStake, long maxStakingRewardRatePerHbar, Fraction nodeRewardFeeFraction, long stakingPeriodsStored, long stakingPeriod, Fraction stakingRewardFeeFraction, long stakingStartThreshold, long stakingRewardRate, long reservedStakingRewards, long unreservedStakingRewardBalance, long rewardBalanceThreshold, long maxStakeRewarded, long maxTotalReward, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.endOfStakingPeriod = endOfStakingPeriod;
            this.nodeStake = nodeStake == null ? Collections.emptyList() : nodeStake;
            this.maxStakingRewardRatePerHbar = maxStakingRewardRatePerHbar;
            this.nodeRewardFeeFraction = nodeRewardFeeFraction;
            this.stakingPeriodsStored = stakingPeriodsStored;
            this.stakingPeriod = stakingPeriod;
            this.stakingRewardFeeFraction = stakingRewardFeeFraction;
            this.stakingStartThreshold = stakingStartThreshold;
            this.stakingRewardRate = stakingRewardRate;
            this.reservedStakingRewards = reservedStakingRewards;
            this.unreservedStakingRewardBalance = unreservedStakingRewardBalance;
            this.rewardBalanceThreshold = rewardBalanceThreshold;
            this.maxStakeRewarded = maxStakeRewarded;
            this.maxTotalReward = maxTotalReward;
        }

        public NodeStakeUpdateTransactionBody build() {
            return new NodeStakeUpdateTransactionBody(this.endOfStakingPeriod, this.nodeStake, this.maxStakingRewardRatePerHbar, this.nodeRewardFeeFraction, this.stakingPeriodsStored, this.stakingPeriod, this.stakingRewardFeeFraction, this.stakingStartThreshold, this.stakingRewardRate, this.reservedStakingRewards, this.unreservedStakingRewardBalance, this.rewardBalanceThreshold, this.maxStakeRewarded, this.maxTotalReward);
        }

        public Builder endOfStakingPeriod(@Nullable Timestamp endOfStakingPeriod) {
            this.endOfStakingPeriod = endOfStakingPeriod;
            return this;
        }

        public Builder endOfStakingPeriod(Timestamp.Builder builder) {
            this.endOfStakingPeriod = builder.build();
            return this;
        }

        public Builder nodeStake(@NonNull List<NodeStake> nodeStake) {
            this.nodeStake = nodeStake != null ? nodeStake : Collections.emptyList();
            return this;
        }

        public Builder nodeStake(NodeStake ... values) {
            this.nodeStake = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder maxStakingRewardRatePerHbar(long maxStakingRewardRatePerHbar) {
            this.maxStakingRewardRatePerHbar = maxStakingRewardRatePerHbar;
            return this;
        }

        public Builder nodeRewardFeeFraction(@Nullable Fraction nodeRewardFeeFraction) {
            this.nodeRewardFeeFraction = nodeRewardFeeFraction;
            return this;
        }

        public Builder nodeRewardFeeFraction(Fraction.Builder builder) {
            this.nodeRewardFeeFraction = builder.build();
            return this;
        }

        public Builder stakingPeriodsStored(long stakingPeriodsStored) {
            this.stakingPeriodsStored = stakingPeriodsStored;
            return this;
        }

        public Builder stakingPeriod(long stakingPeriod) {
            this.stakingPeriod = stakingPeriod;
            return this;
        }

        public Builder stakingRewardFeeFraction(@Nullable Fraction stakingRewardFeeFraction) {
            this.stakingRewardFeeFraction = stakingRewardFeeFraction;
            return this;
        }

        public Builder stakingRewardFeeFraction(Fraction.Builder builder) {
            this.stakingRewardFeeFraction = builder.build();
            return this;
        }

        public Builder stakingStartThreshold(long stakingStartThreshold) {
            this.stakingStartThreshold = stakingStartThreshold;
            return this;
        }

        public Builder stakingRewardRate(long stakingRewardRate) {
            this.stakingRewardRate = stakingRewardRate;
            return this;
        }

        public Builder reservedStakingRewards(long reservedStakingRewards) {
            this.reservedStakingRewards = reservedStakingRewards;
            return this;
        }

        public Builder unreservedStakingRewardBalance(long unreservedStakingRewardBalance) {
            this.unreservedStakingRewardBalance = unreservedStakingRewardBalance;
            return this;
        }

        public Builder rewardBalanceThreshold(long rewardBalanceThreshold) {
            this.rewardBalanceThreshold = rewardBalanceThreshold;
            return this;
        }

        public Builder maxStakeRewarded(long maxStakeRewarded) {
            this.maxStakeRewarded = maxStakeRewarded;
            return this;
        }

        public Builder maxTotalReward(long maxTotalReward) {
            this.maxTotalReward = maxTotalReward;
            return this;
        }

        public Timestamp endOfStakingPeriod() {
            return this.endOfStakingPeriod;
        }

        public List<NodeStake> nodeStake() {
            return this.nodeStake;
        }

        public long maxStakingRewardRatePerHbar() {
            return this.maxStakingRewardRatePerHbar;
        }

        public Fraction nodeRewardFeeFraction() {
            return this.nodeRewardFeeFraction;
        }

        public long stakingPeriodsStored() {
            return this.stakingPeriodsStored;
        }

        public long stakingPeriod() {
            return this.stakingPeriod;
        }

        public Fraction stakingRewardFeeFraction() {
            return this.stakingRewardFeeFraction;
        }

        public long stakingStartThreshold() {
            return this.stakingStartThreshold;
        }

        public long stakingRewardRate() {
            return this.stakingRewardRate;
        }

        public long reservedStakingRewards() {
            return this.reservedStakingRewards;
        }

        public long unreservedStakingRewardBalance() {
            return this.unreservedStakingRewardBalance;
        }

        public long rewardBalanceThreshold() {
            return this.rewardBalanceThreshold;
        }

        public long maxStakeRewarded() {
            return this.maxStakeRewarded;
        }

        public long maxTotalReward() {
            return this.maxTotalReward;
        }
    }
}

