/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.api.Condition;
import org.assertj.core.description.Description;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.util.VisibleForTesting;

public class ShouldSatisfy
extends BasicErrorMessageFactory {
    @VisibleForTesting
    public static final String CONDITION_SHOULD_BE_SATISFIED = "%nExpecting actual:%n  %s%nto satisfy:%n  %s";
    @VisibleForTesting
    public static final String CONSUMERS_SHOULD_BE_SATISFIED_IN_ANY_ORDER = "%nExpecting actual:%n  %s%nto satisfy all the consumers in any order.";
    @VisibleForTesting
    public static final String CONSUMERS_SHOULD_NOT_BE_NULL = "The Consumer<? super E>... expressing the assertions consumers must not be null";

    public static <T> ErrorMessageFactory shouldSatisfy(T actual, Condition<? super T> condition) {
        return new ShouldSatisfy(actual, condition);
    }

    public static <E> ErrorMessageFactory shouldSatisfyExactlyInAnyOrder(Iterable<E> actual) {
        return new ShouldSatisfy(actual);
    }

    private ShouldSatisfy(Object actual, Condition<?> condition) {
        super(CONDITION_SHOULD_BE_SATISFIED, actual, condition);
    }

    public static ErrorMessageFactory shouldSatisfyAll(Object actual, Description d) {
        return new ShouldSatisfy(actual, d);
    }

    private ShouldSatisfy(Object actual, Description d) {
        super(CONDITION_SHOULD_BE_SATISFIED, actual, d);
    }

    private <E> ShouldSatisfy(Iterable<E> actual) {
        super(CONSUMERS_SHOULD_BE_SATISFIED_IN_ANY_ORDER, actual);
    }
}

