/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.internal.network;

import com.hedera.node.internal.network.codec.BlockNodeConfigJsonCodec;
import com.hedera.node.internal.network.codec.BlockNodeConfigProtoCodec;
import com.hedera.node.internal.network.schema.BlockNodeConfigSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class BlockNodeConfig {
    public static final Codec<BlockNodeConfig> PROTOBUF = new BlockNodeConfigProtoCodec();
    public static final JsonCodec<BlockNodeConfig> JSON = new BlockNodeConfigJsonCodec();
    public static final BlockNodeConfig DEFAULT = BlockNodeConfig.newBuilder().build();
    @NonNull
    private final String address;
    private final int port;
    private final int priority;
    @Nullable
    private final Long messageSizeSoftLimitBytes;
    @Nullable
    private final Long messageSizeHardLimitBytes;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public BlockNodeConfig(String address, int port, int priority, Long messageSizeSoftLimitBytes, Long messageSizeHardLimitBytes) {
        this.$unknownFields = null;
        this.address = address != null ? address : "";
        this.port = port;
        this.priority = priority;
        this.messageSizeSoftLimitBytes = messageSizeSoftLimitBytes;
        this.messageSizeHardLimitBytes = messageSizeHardLimitBytes;
    }

    public BlockNodeConfig(String address, int port, int priority, Long messageSizeSoftLimitBytes, Long messageSizeHardLimitBytes, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.address = address != null ? address : "";
        this.port = port;
        this.priority = priority;
        this.messageSizeSoftLimitBytes = messageSizeSoftLimitBytes;
        this.messageSizeHardLimitBytes = messageSizeHardLimitBytes;
    }

    public String address() {
        return this.address;
    }

    public int port() {
        return this.port;
    }

    public int priority() {
        return this.priority;
    }

    public Long messageSizeSoftLimitBytes() {
        return this.messageSizeSoftLimitBytes;
    }

    public Long messageSizeHardLimitBytes() {
        return this.messageSizeHardLimitBytes;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfString((FieldDefinition)BlockNodeConfigSchema.ADDRESS, (String)this.address, (boolean)true);
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)BlockNodeConfigSchema.PORT, (int)this.port, (boolean)true);
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)BlockNodeConfigSchema.PRIORITY, (int)this.priority, (boolean)true);
            _size += ProtoWriterTools.sizeOfOptionalLong((FieldDefinition)BlockNodeConfigSchema.MESSAGE_SIZE_SOFT_LIMIT_BYTES, (Long)this.messageSizeSoftLimitBytes);
            _size += ProtoWriterTools.sizeOfOptionalLong((FieldDefinition)BlockNodeConfigSchema.MESSAGE_SIZE_HARD_LIMIT_BYTES, (Long)this.messageSizeHardLimitBytes);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.address != null && !this.address.equals(BlockNodeConfig.DEFAULT.address)) {
                result = 31 * result + this.address.hashCode();
            }
            if (this.port != BlockNodeConfig.DEFAULT.port) {
                result = 31 * result + Integer.hashCode(this.port);
            }
            if (this.priority != BlockNodeConfig.DEFAULT.priority) {
                result = 31 * result + Integer.hashCode(this.priority);
            }
            if (this.messageSizeSoftLimitBytes != null && !this.messageSizeSoftLimitBytes.equals(BlockNodeConfig.DEFAULT.messageSizeSoftLimitBytes)) {
                result = 31 * result + Long.hashCode(this.messageSizeSoftLimitBytes);
            }
            if (this.messageSizeHardLimitBytes != null && !this.messageSizeHardLimitBytes.equals(BlockNodeConfig.DEFAULT.messageSizeHardLimitBytes)) {
                result = 31 * result + Long.hashCode(this.messageSizeHardLimitBytes);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        BlockNodeConfig thatObj = (BlockNodeConfig)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.address == null && thatObj.address != null) {
            return false;
        }
        if (this.address != null && !this.address.equals(thatObj.address)) {
            return false;
        }
        if (this.port != thatObj.port) {
            return false;
        }
        if (this.priority != thatObj.priority) {
            return false;
        }
        if (this.messageSizeSoftLimitBytes == null && thatObj.messageSizeSoftLimitBytes != null) {
            return false;
        }
        if (this.messageSizeSoftLimitBytes != null && !this.messageSizeSoftLimitBytes.equals(thatObj.messageSizeSoftLimitBytes)) {
            return false;
        }
        if (this.messageSizeHardLimitBytes == null && thatObj.messageSizeHardLimitBytes != null) {
            return false;
        }
        if (this.messageSizeHardLimitBytes != null && !this.messageSizeHardLimitBytes.equals(thatObj.messageSizeHardLimitBytes)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "BlockNodeConfig[address=" + this.address + ", port=" + this.port + ", priority=" + this.priority + ", messageSizeSoftLimitBytes=" + this.messageSizeSoftLimitBytes + ", messageSizeHardLimitBytes=" + this.messageSizeHardLimitBytes + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasMessageSizeSoftLimitBytes() {
        return this.messageSizeSoftLimitBytes != null;
    }

    public Long messageSizeSoftLimitBytesOrElse(@NonNull Long defaultValue) {
        return this.hasMessageSizeSoftLimitBytes() ? this.messageSizeSoftLimitBytes : defaultValue;
    }

    @NonNull
    public Long messageSizeSoftLimitBytesOrThrow() {
        return Objects.requireNonNull(this.messageSizeSoftLimitBytes, "Field messageSizeSoftLimitBytes is null");
    }

    public void ifMessageSizeSoftLimitBytes(@NonNull Consumer<Long> ifPresent) {
        if (this.hasMessageSizeSoftLimitBytes()) {
            ifPresent.accept(this.messageSizeSoftLimitBytes);
        }
    }

    public boolean hasMessageSizeHardLimitBytes() {
        return this.messageSizeHardLimitBytes != null;
    }

    public Long messageSizeHardLimitBytesOrElse(@NonNull Long defaultValue) {
        return this.hasMessageSizeHardLimitBytes() ? this.messageSizeHardLimitBytes : defaultValue;
    }

    @NonNull
    public Long messageSizeHardLimitBytesOrThrow() {
        return Objects.requireNonNull(this.messageSizeHardLimitBytes, "Field messageSizeHardLimitBytes is null");
    }

    public void ifMessageSizeHardLimitBytes(@NonNull Consumer<Long> ifPresent) {
        if (this.hasMessageSizeHardLimitBytes()) {
            ifPresent.accept(this.messageSizeHardLimitBytes);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.address, this.port, this.priority, this.messageSizeSoftLimitBytes, this.messageSizeHardLimitBytes, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @NonNull
        private String address = "";
        private int port = 0;
        private int priority = 0;
        @Nullable
        private Long messageSizeSoftLimitBytes = null;
        @Nullable
        private Long messageSizeHardLimitBytes = null;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(String address, int port, int priority, Long messageSizeSoftLimitBytes, Long messageSizeHardLimitBytes) {
            this.$unknownFields = null;
            this.address = address != null ? address : "";
            this.port = port;
            this.priority = priority;
            this.messageSizeSoftLimitBytes = messageSizeSoftLimitBytes;
            this.messageSizeHardLimitBytes = messageSizeHardLimitBytes;
        }

        public Builder(String address, int port, int priority, Long messageSizeSoftLimitBytes, Long messageSizeHardLimitBytes, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.address = address != null ? address : "";
            this.port = port;
            this.priority = priority;
            this.messageSizeSoftLimitBytes = messageSizeSoftLimitBytes;
            this.messageSizeHardLimitBytes = messageSizeHardLimitBytes;
        }

        public BlockNodeConfig build() {
            return new BlockNodeConfig(this.address, this.port, this.priority, this.messageSizeSoftLimitBytes, this.messageSizeHardLimitBytes);
        }

        public Builder address(@NonNull String address) {
            this.address = address != null ? address : "";
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder messageSizeSoftLimitBytes(@Nullable Long messageSizeSoftLimitBytes) {
            this.messageSizeSoftLimitBytes = messageSizeSoftLimitBytes;
            return this;
        }

        public Builder messageSizeHardLimitBytes(@Nullable Long messageSizeHardLimitBytes) {
            this.messageSizeHardLimitBytes = messageSizeHardLimitBytes;
            return this;
        }

        public String address() {
            return this.address;
        }

        public int port() {
            return this.port;
        }

        public int priority() {
            return this.priority;
        }

        public Long messageSizeSoftLimitBytes() {
            return this.messageSizeSoftLimitBytes;
        }

        public Long messageSizeHardLimitBytes() {
            return this.messageSizeHardLimitBytes;
        }
    }
}

