/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkle.test.fixtures.map.benchmark.operations;

import com.swirlds.common.test.fixtures.benchmark.AbstractBenchmarkOperation;
import com.swirlds.merkle.map.MerkleMap;
import com.swirlds.merkle.test.fixtures.map.benchmark.AccountFactory;
import com.swirlds.merkle.test.fixtures.map.benchmark.BenchmarkAccount;
import com.swirlds.merkle.test.fixtures.map.benchmark.BenchmarkKey;
import com.swirlds.merkle.test.fixtures.map.benchmark.MerkleMapBenchmarkMetadata;
import java.util.Random;
import org.hiero.base.utility.test.fixtures.RandomUtils;

public class CreateAccountOperation<A extends BenchmarkAccount, M extends MerkleMapBenchmarkMetadata>
extends AbstractBenchmarkOperation<MerkleMap<BenchmarkKey, A>, M> {
    private BenchmarkKey fromKey;
    private long newFromBalance;
    private BenchmarkKey newAccountKey;
    private A newAccount;
    private BenchmarkKey nodeFeeKey;
    private long newNodeBalance;
    private BenchmarkKey networkFeeKey;
    private long newNetworkBalance;
    private final int dataSize;
    private AccountFactory<A> accountFactory;

    public CreateAccountOperation(double weight, int dataSize, AccountFactory<A> accountFactory) {
        super(weight);
        this.dataSize = dataSize;
        this.accountFactory = accountFactory;
    }

    private CreateAccountOperation(CreateAccountOperation<A, M> that) {
        super(that.getWeight());
        this.dataSize = that.dataSize;
        this.accountFactory = that.accountFactory;
    }

    public String getName() {
        return "createAccount";
    }

    public void prepare(M metadata, Random random) {
        this.fromKey = ((MerkleMapBenchmarkMetadata)metadata).getRandomKey(random);
        this.newFromBalance = random.nextLong();
        this.newAccountKey = ((MerkleMapBenchmarkMetadata)metadata).getNewKey();
        this.newAccount = this.accountFactory.buildAccount(random.nextLong(), RandomUtils.randomByteArray((Random)random, (int)this.dataSize));
        this.nodeFeeKey = ((MerkleMapBenchmarkMetadata)metadata).getRandomNodeFeeKey(random);
        this.newNodeBalance = random.nextLong();
        this.networkFeeKey = ((MerkleMapBenchmarkMetadata)metadata).getNetworkFeeKey();
        this.newNetworkBalance = random.nextLong();
    }

    public void execute(MerkleMap<BenchmarkKey, A> state) {
        BenchmarkAccount fromAccount = (BenchmarkAccount)state.getForModify((Object)this.fromKey);
        BenchmarkAccount nodeAccount = (BenchmarkAccount)state.getForModify((Object)this.nodeFeeKey);
        BenchmarkAccount networkAccount = (BenchmarkAccount)state.getForModify((Object)this.networkFeeKey);
        fromAccount.setBalance(this.newFromBalance);
        nodeAccount.setBalance(this.newNodeBalance);
        networkAccount.setBalance(this.newNetworkBalance);
        state.put((Object)this.newAccountKey, this.newAccount);
    }

    public CreateAccountOperation<A, M> copy() {
        return new CreateAccountOperation<A, M>(this);
    }
}

