/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.communication.states;

import com.swirlds.platform.network.NetworkProtocolException;
import com.swirlds.platform.network.communication.NegotiationException;
import com.swirlds.platform.network.communication.NegotiatorBytes;
import com.swirlds.platform.network.communication.states.NegotiationState;
import com.swirlds.platform.network.communication.states.NegotiationStateWithDescription;
import com.swirlds.platform.network.communication.states.ReceivedInitiate;
import java.io.IOException;
import java.io.InputStream;

public class SentKeepalive
extends NegotiationStateWithDescription {
    private final InputStream byteInput;
    private final NegotiationState sleep;
    private final ReceivedInitiate receivedInitiate;

    public SentKeepalive(InputStream byteInput, NegotiationState sleep, ReceivedInitiate receivedInitiate) {
        this.byteInput = byteInput;
        this.sleep = sleep;
        this.receivedInitiate = receivedInitiate;
    }

    @Override
    public NegotiationState transition() throws NegotiationException, NetworkProtocolException, InterruptedException, IOException {
        int b = this.byteInput.read();
        NegotiatorBytes.checkByte(b);
        return switch (b) {
            case 255 -> {
                this.setDescription("both sent keepalive");
                yield this.sleep;
            }
            case 253, 254 -> throw new NegotiationException("Unexpected ACCEPT or REJECT");
            default -> {
                this.setDescription("received initiate - " + b);
                yield this.receivedInitiate.receivedInitiate(b);
            }
        };
    }
}

