/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.virtualmerkle.transaction.pool;

import com.google.protobuf.ByteString;
import com.swirlds.base.utility.Pair;
import com.swirlds.demo.merkle.map.internal.ExpectedFCMFamily;
import com.swirlds.demo.platform.PAYLOAD_TYPE;
import com.swirlds.demo.platform.Triple;
import com.swirlds.demo.platform.fs.stresstest.proto.Activity;
import com.swirlds.demo.platform.fs.stresstest.proto.FCMTransaction;
import com.swirlds.demo.platform.fs.stresstest.proto.TestTransaction;
import com.swirlds.demo.platform.fs.stresstest.proto.VirtualMerkleTransaction;
import com.swirlds.demo.virtualmerkle.config.TransactionRequestConfig;
import com.swirlds.demo.virtualmerkle.config.TransactionRequestSupplierFactory;
import com.swirlds.demo.virtualmerkle.config.VirtualMerkleConfig;
import com.swirlds.demo.virtualmerkle.random.PTTRandom;
import com.swirlds.demo.virtualmerkle.transaction.pool.AccountTransactionFactory;
import com.swirlds.demo.virtualmerkle.transaction.pool.SmartContractTransactionFactory;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import java.util.function.Supplier;

public class VirtualMerkleTransactionPool {
    private final Supplier<TransactionRequestConfig> transactionRequestSupplier;
    private final AccountTransactionFactory accountTransactionFactory;
    private final SmartContractTransactionFactory smartContractTransactionFactory;
    private final long nodeId;
    private final VirtualMerkleConfig virtualMerkleConfig;

    public VirtualMerkleTransactionPool(long nodeId, VirtualMerkleConfig virtualMerkleConfig, ExpectedFCMFamily expectedFCMFamily) {
        PTTRandom random = new PTTRandom();
        this.nodeId = nodeId;
        this.accountTransactionFactory = new AccountTransactionFactory(random, virtualMerkleConfig.getSamplingProbability(), expectedFCMFamily, nodeId, virtualMerkleConfig.getTotalAccountCreations(), virtualMerkleConfig.getFirstAccountId());
        this.smartContractTransactionFactory = new SmartContractTransactionFactory(random, nodeId, virtualMerkleConfig.getTotalSmartContractCreations(), virtualMerkleConfig.getSmartContractConfig(), virtualMerkleConfig.getFirstSmartContractId());
        this.transactionRequestSupplier = TransactionRequestSupplierFactory.create(virtualMerkleConfig);
        this.virtualMerkleConfig = virtualMerkleConfig;
    }

    public Triple<byte[], PAYLOAD_TYPE, MapKey> getTransaction() {
        TransactionRequestConfig currentTransactionConfig = this.transactionRequestSupplier.get();
        if (currentTransactionConfig == null) {
            return null;
        }
        return this.createNewTransaction(currentTransactionConfig);
    }

    private Triple<byte[], PAYLOAD_TYPE, MapKey> createNewTransaction(TransactionRequestConfig currentTransactionConfig) {
        PAYLOAD_TYPE generateType = currentTransactionConfig.getType();
        if (generateType == PAYLOAD_TYPE.TYPE_VIRTUAL_MERKLE_CREATE) {
            Pair<MapKey, VirtualMerkleTransaction.Builder> mapAndTransaction = this.accountTransactionFactory.buildCreateAccountTransaction();
            return this.buildTransactionTriple((VirtualMerkleTransaction.Builder)mapAndTransaction.value(), generateType, (MapKey)mapAndTransaction.key(), AccountTransactionFactory.getSizeAfterPadding());
        }
        if (generateType == PAYLOAD_TYPE.TYPE_VIRTUAL_MERKLE_UPDATE || generateType == PAYLOAD_TYPE.TYPE_VIRTUAL_MERKLE_DELETE && this.virtualMerkleConfig.isBypassDeleteTransaction()) {
            Pair<MapKey, VirtualMerkleTransaction.Builder> mapAndTransaction = this.accountTransactionFactory.buildUpdateAccountTransaction(currentTransactionConfig.getHotspot());
            return this.buildTransactionTriple((VirtualMerkleTransaction.Builder)mapAndTransaction.value(), generateType, (MapKey)mapAndTransaction.key(), AccountTransactionFactory.getSizeAfterPadding());
        }
        if (generateType == PAYLOAD_TYPE.TYPE_VIRTUAL_MERKLE_DELETE) {
            Pair<MapKey, VirtualMerkleTransaction.Builder> mapAndTransaction = this.accountTransactionFactory.buildDeleteAccountTransaction();
            return this.buildTransactionTriple((VirtualMerkleTransaction.Builder)mapAndTransaction.value(), generateType, (MapKey)mapAndTransaction.key(), AccountTransactionFactory.getSizeAfterPadding());
        }
        if (generateType == PAYLOAD_TYPE.TYPE_VIRTUAL_MERKLE_CREATE_SMART_CONTRACT) {
            VirtualMerkleTransaction.Builder builder = this.smartContractTransactionFactory.buildCreateSmartContractTransaction();
            return this.buildTransactionTriple(builder, generateType, null, SmartContractTransactionFactory.getSizeAfterPadding());
        }
        if (generateType == PAYLOAD_TYPE.TYPE_VIRTUAL_MERKLE_SMART_CONTRACT_METHOD_EXECUTION) {
            VirtualMerkleTransaction.Builder builder = this.smartContractTransactionFactory.buildMethodExecutionTransaction(currentTransactionConfig.getHotspot());
            return this.buildTransactionTriple(builder, generateType, null, SmartContractTransactionFactory.getSizeAfterPadding());
        }
        if (generateType == PAYLOAD_TYPE.SAVE_EXPECTED_MAP) {
            FCMTransaction fcmTransaction = FCMTransaction.newBuilder().setActivity(Activity.newBuilder().setType(Activity.ActivityType.SAVE_EXPECTED_MAP)).setOriginNode(this.nodeId).build();
            byte[] transactionBytes = TestTransaction.newBuilder().setFcmTransaction(fcmTransaction).build().toByteArray();
            PAYLOAD_TYPE payloadType = PAYLOAD_TYPE.BodyCase_TO_PAYLOAD_TYPE.get((Object)fcmTransaction.getBodyCase());
            return Triple.of(transactionBytes, payloadType, null);
        }
        String msg = String.format("The given type %s was not recognized as a Virtual Merkle transaction type.", new Object[]{generateType});
        throw new RuntimeException(msg);
    }

    private Triple<byte[], PAYLOAD_TYPE, MapKey> buildTransactionTriple(VirtualMerkleTransaction.Builder virtualMerkleTransactionBuilder, PAYLOAD_TYPE payloadType, MapKey key, int sizeAfterPadding) {
        VirtualMerkleTransaction transaction = virtualMerkleTransactionBuilder.build();
        int length = transaction.toByteArray().length;
        if (length < sizeAfterPadding) {
            virtualMerkleTransactionBuilder.setPaddingBytes(ByteString.copyFrom((byte[])new byte[sizeAfterPadding - length]));
        }
        byte[] transactionBytes = TestTransaction.newBuilder().setVirtualMerkleTransaction(virtualMerkleTransactionBuilder).build().toByteArray();
        return Triple.of(transactionBytes, payloadType, key);
    }
}

