/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.addressbook;

import com.swirlds.platform.crypto.KeyCertPurpose;
import com.swirlds.platform.crypto.KeysAndCertsGenerator;
import com.swirlds.platform.crypto.PublicStores;
import com.swirlds.platform.test.fixtures.addressbook.RandomAddressBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.roster.AddressBook;
import org.hiero.consensus.model.roster.SerializableX509Certificate;

public class RandomAddressBookBuilder {
    private final Random random;
    private int size = 4;
    private WeightDistributionStrategy weightDistributionStrategy = WeightDistributionStrategy.GAUSSIAN;
    private long averageWeight = 1000L;
    private long weightStandardDeviation = 100L;
    private long minimumWeight = 0L;
    private Long maximumWeight;
    private NodeId nextNodeId = NodeId.FIRST_NODE_ID;
    private boolean realKeys;
    private final Map<NodeId, KeysAndCerts> privateKeys = new HashMap<NodeId, KeysAndCerts>();

    @NonNull
    public static RandomAddressBookBuilder create(@NonNull Random random) {
        return new RandomAddressBookBuilder(random);
    }

    private RandomAddressBookBuilder(@NonNull Random random) {
        this.random = Objects.requireNonNull(random);
    }

    @NonNull
    public AddressBook build() {
        AddressBook addressBook = new AddressBook();
        addressBook.setRound(Math.abs(this.random.nextLong()));
        if (this.maximumWeight == null && this.size > 0) {
            this.maximumWeight = Long.MAX_VALUE / (long)this.size;
        }
        for (int index = 0; index < this.size; ++index) {
            NodeId nodeId = this.getNextNodeId();
            RandomAddressBuilder addressBuilder = RandomAddressBuilder.create(this.random).withNodeId(nodeId).withWeight(this.getNextWeight());
            this.generateKeys(nodeId, addressBuilder);
            addressBook.add(addressBuilder.build());
        }
        return addressBook;
    }

    @NonNull
    public RandomAddressBookBuilder withSize(int size) {
        this.size = size;
        return this;
    }

    @NonNull
    public RandomAddressBookBuilder withAverageWeight(long averageWeight) {
        this.averageWeight = averageWeight;
        return this;
    }

    @NonNull
    public RandomAddressBookBuilder withWeightStandardDeviation(long weightStandardDeviation) {
        this.weightStandardDeviation = weightStandardDeviation;
        return this;
    }

    @NonNull
    public RandomAddressBookBuilder withMinimumWeight(long minimumWeight) {
        this.minimumWeight = minimumWeight;
        return this;
    }

    @NonNull
    public RandomAddressBookBuilder withMaximumWeight(long maximumWeight) {
        this.maximumWeight = maximumWeight;
        return this;
    }

    @NonNull
    public RandomAddressBookBuilder withWeightDistributionStrategy(WeightDistributionStrategy weightDistributionStrategy) {
        this.weightDistributionStrategy = weightDistributionStrategy;
        return this;
    }

    @NonNull
    public RandomAddressBookBuilder withRealKeysEnabled(boolean realKeysEnabled) {
        this.realKeys = realKeysEnabled;
        return this;
    }

    @NonNull
    public KeysAndCerts getPrivateKeys(NodeId nodeId) {
        if (!this.realKeys) {
            throw new IllegalStateException("Real keys are not being generated");
        }
        if (!this.privateKeys.containsKey(nodeId)) {
            throw new IllegalStateException("Unknown node ID " + String.valueOf(nodeId));
        }
        return this.privateKeys.get(nodeId);
    }

    @NonNull
    private NodeId getNextNodeId() {
        NodeId nextId = this.nextNodeId;
        int randomAdvance = this.random.nextInt(3);
        this.nextNodeId = this.nextNodeId.getOffset((long)randomAdvance + 1L);
        return nextId;
    }

    private long getNextWeight() {
        return Math.min(this.maximumWeight, Math.max(this.minimumWeight, switch (this.weightDistributionStrategy.ordinal()) {
            case 0 -> this.averageWeight;
            case 1 -> Math.max(0L, (long)((double)this.averageWeight + this.random.nextGaussian() * (double)this.weightStandardDeviation));
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.weightDistributionStrategy));
        }));
    }

    private void generateKeys(@NonNull NodeId nodeId, @NonNull RandomAddressBuilder addressBuilder) {
        if (this.realKeys) {
            try {
                PublicStores publicStores = new PublicStores();
                byte[] masterKey = new byte[64];
                this.random.nextBytes(masterKey);
                KeysAndCerts keysAndCerts = KeysAndCertsGenerator.generate((NodeId)nodeId, (byte[])new byte[0], (byte[])masterKey, (byte[])new byte[0], (PublicStores)publicStores);
                this.privateKeys.put(nodeId, keysAndCerts);
                SerializableX509Certificate sigCert = new SerializableX509Certificate(publicStores.getCertificate(KeyCertPurpose.SIGNING, nodeId));
                SerializableX509Certificate agrCert = new SerializableX509Certificate(publicStores.getCertificate(KeyCertPurpose.AGREEMENT, nodeId));
                addressBuilder.withSigCert(sigCert).withAgreeCert(agrCert);
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }
    }

    public static enum WeightDistributionStrategy {
        BALANCED,
        GAUSSIAN;

    }
}

