/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl.rules;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hiero.consensus.event.creator.impl.EventCreationStatus;
import org.hiero.consensus.event.creator.impl.rules.EventCreationRule;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.model.transaction.SignatureTransactionCheck;

public class PlatformStatusRule
implements EventCreationRule {
    private final SignatureTransactionCheck signatureTransactionCheck;
    private PlatformStatus platformStatus;

    public PlatformStatusRule(@NonNull SignatureTransactionCheck signatureTransactionCheck) {
        this.signatureTransactionCheck = Objects.requireNonNull(signatureTransactionCheck);
    }

    @Override
    public boolean isEventCreationPermitted() {
        PlatformStatus currentStatus = this.platformStatus;
        if (currentStatus == PlatformStatus.FREEZING) {
            return this.signatureTransactionCheck.hasBufferedSignatureTransactions();
        }
        return currentStatus == PlatformStatus.ACTIVE || currentStatus == PlatformStatus.CHECKING;
    }

    public void setPlatformStatus(PlatformStatus platformStatus) {
        this.platformStatus = platformStatus;
    }

    @Override
    public void eventWasCreated() {
    }

    @Override
    @NonNull
    public EventCreationStatus getEventCreationStatus() {
        return EventCreationStatus.PLATFORM_STATUS;
    }
}

