/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.metrics.api;

import com.swirlds.base.ArgumentUtils;
import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricsFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public abstract class MetricConfig<T extends Metric, C extends MetricConfig<T, C>> {
    private static final int MAX_DESCRIPTION_LENGTH = 255;
    @NonNull
    private final String category;
    @NonNull
    private final String name;
    @NonNull
    private final String description;
    @NonNull
    private final String unit;
    @NonNull
    private final String format;

    protected MetricConfig(@NonNull String category, @NonNull String name, @NonNull String description, @NonNull String unit, @NonNull String format) {
        this.category = ArgumentUtils.throwArgBlank((String)category, (String)"category");
        this.name = ArgumentUtils.throwArgBlank((String)name, (String)"name");
        this.description = ArgumentUtils.throwArgBlank((String)description, (String)"description");
        if (description.length() > 255) {
            throw new IllegalArgumentException("Description has " + description.length() + " characters, must not be longer than 255 characters: " + description);
        }
        this.unit = Objects.requireNonNull(unit, "unit must not be null");
        this.format = ArgumentUtils.throwArgBlank((String)format, (String)"format must not be null");
    }

    protected MetricConfig(@NonNull String category, @NonNull String name, @NonNull String defaultFormat) {
        this(category, name, name, "", defaultFormat);
    }

    @NonNull
    public String getCategory() {
        return this.category;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public abstract C withDescription(String var1);

    @NonNull
    public String getUnit() {
        return this.unit;
    }

    @NonNull
    public abstract C withUnit(String var1);

    @NonNull
    public String getFormat() {
        return this.format;
    }

    @NonNull
    public abstract Class<T> getResultClass();

    @NonNull
    public abstract T create(MetricsFactory var1);

    public String toString() {
        return new ToStringBuilder((Object)this).append("category", (Object)this.category).append("name", (Object)this.name).append("description", (Object)this.description).append("unit", (Object)this.unit).append("format", (Object)this.format).append("resultClass", this.getResultClass()).toString();
    }

    public static Metric.DataType mapDataType(Class<?> type) {
        if (Double.class.equals(type) || Float.class.equals(type)) {
            return Metric.DataType.FLOAT;
        }
        if (Number.class.isAssignableFrom(type)) {
            return Metric.DataType.INT;
        }
        if (Boolean.class.equals(type)) {
            return Metric.DataType.BOOLEAN;
        }
        return Metric.DataType.STRING;
    }
}

