/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Objects;
import org.hiero.base.crypto.SignatureType;

public final class FileSigningUtils {
    public static final String SIGNATURE_FILE_NAME_SUFFIX = "_sig";
    private static final String KEYSTORE_TYPE = "pkcs12";

    private FileSigningUtils() {
    }

    @NonNull
    public static Path buildSignatureFilePath(@NonNull Path destinationDirectory, @NonNull Path sourceFile) {
        Objects.requireNonNull(destinationDirectory, "destinationDirectory must not be null");
        Objects.requireNonNull(sourceFile, "sourceFile must not be null");
        try {
            Files.createDirectories(destinationDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create directory", e);
        }
        return destinationDirectory.resolve(String.valueOf(sourceFile.getFileName()) + SIGNATURE_FILE_NAME_SUFFIX);
    }

    @NonNull
    public static byte[] signData(@NonNull byte[] data, @NonNull KeyPair keyPair) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        Objects.requireNonNull(data, "data must not be null");
        Objects.requireNonNull(keyPair, "keyPair must not be null");
        Signature signature = Signature.getInstance(SignatureType.RSA.signingAlgorithm(), SignatureType.RSA.provider());
        signature.initSign(keyPair.getPrivate());
        signature.update(data);
        return signature.sign();
    }

    @NonNull
    public static KeyPair loadPfxKey(@NonNull Path keyFile, @NonNull String password, @NonNull String alias) {
        KeyPair keyPair;
        block8: {
            Objects.requireNonNull(keyFile, "keyFile must not be null");
            Objects.requireNonNull(password, "password must not be null");
            Objects.requireNonNull(alias, "alias must not be null");
            InputStream inputStream = Files.newInputStream(keyFile, new OpenOption[0]);
            try {
                KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
                keyStore.load(inputStream, password.toCharArray());
                keyPair = new KeyPair(keyStore.getCertificate(alias).getPublicKey(), (PrivateKey)keyStore.getKey(alias, password.toCharArray()));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                    throw new RuntimeException("Unable to load Pfx key from file: " + String.valueOf(keyFile), e);
                }
            }
            inputStream.close();
        }
        return keyPair;
    }
}

