/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.transaction.codec.AssessedCustomFeeJsonCodec;
import com.hedera.hapi.node.transaction.codec.AssessedCustomFeeProtoCodec;
import com.hedera.hapi.node.transaction.schema.AssessedCustomFeeSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class AssessedCustomFee {
    public static final Codec<AssessedCustomFee> PROTOBUF = new AssessedCustomFeeProtoCodec();
    public static final JsonCodec<AssessedCustomFee> JSON = new AssessedCustomFeeJsonCodec();
    public static final AssessedCustomFee DEFAULT = AssessedCustomFee.newBuilder().build();
    private final long amount;
    @Nullable
    private final TokenID tokenId;
    @Nullable
    private final AccountID feeCollectorAccountId;
    @NonNull
    private final List<AccountID> effectivePayerAccountId;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public AssessedCustomFee(long amount, TokenID tokenId, AccountID feeCollectorAccountId, List<AccountID> effectivePayerAccountId) {
        this.$unknownFields = null;
        this.amount = amount;
        this.tokenId = tokenId;
        this.feeCollectorAccountId = feeCollectorAccountId;
        this.effectivePayerAccountId = effectivePayerAccountId == null ? Collections.emptyList() : effectivePayerAccountId;
    }

    public AssessedCustomFee(long amount, TokenID tokenId, AccountID feeCollectorAccountId, List<AccountID> effectivePayerAccountId, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.amount = amount;
        this.tokenId = tokenId;
        this.feeCollectorAccountId = feeCollectorAccountId;
        this.effectivePayerAccountId = effectivePayerAccountId == null ? Collections.emptyList() : effectivePayerAccountId;
    }

    public long amount() {
        return this.amount;
    }

    public TokenID tokenId() {
        return this.tokenId;
    }

    public AccountID feeCollectorAccountId() {
        return this.feeCollectorAccountId;
    }

    public List<AccountID> effectivePayerAccountId() {
        return this.effectivePayerAccountId;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)AssessedCustomFeeSchema.AMOUNT, (long)this.amount, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AssessedCustomFeeSchema.TOKEN_ID, (Object)this.tokenId, TokenID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AssessedCustomFeeSchema.FEE_COLLECTOR_ACCOUNT_ID, (Object)this.feeCollectorAccountId, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)AssessedCustomFeeSchema.EFFECTIVE_PAYER_ACCOUNT_ID, this.effectivePayerAccountId, AccountID.PROTOBUF);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            List<AccountID> list$effectivePayerAccountId;
            int result = 1;
            if (this.amount != AssessedCustomFee.DEFAULT.amount) {
                result = 31 * result + Long.hashCode(this.amount);
            }
            if (this.tokenId != null && !this.tokenId.equals(AssessedCustomFee.DEFAULT.tokenId)) {
                result = 31 * result + this.tokenId.hashCode();
            }
            if (this.feeCollectorAccountId != null && !this.feeCollectorAccountId.equals(AssessedCustomFee.DEFAULT.feeCollectorAccountId)) {
                result = 31 * result + this.feeCollectorAccountId.hashCode();
            }
            if ((list$effectivePayerAccountId = this.effectivePayerAccountId) != null) {
                for (AccountID o : list$effectivePayerAccountId) {
                    if (o != null) {
                        result = 31 * result + ((Object)o).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        AssessedCustomFee thatObj = (AssessedCustomFee)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.amount != thatObj.amount) {
            return false;
        }
        if (this.tokenId == null && thatObj.tokenId != null) {
            return false;
        }
        if (this.tokenId != null && !this.tokenId.equals(thatObj.tokenId)) {
            return false;
        }
        if (this.feeCollectorAccountId == null && thatObj.feeCollectorAccountId != null) {
            return false;
        }
        if (this.feeCollectorAccountId != null && !this.feeCollectorAccountId.equals(thatObj.feeCollectorAccountId)) {
            return false;
        }
        if (this.effectivePayerAccountId == null && thatObj.effectivePayerAccountId != null) {
            return false;
        }
        if (this.effectivePayerAccountId != null && !this.effectivePayerAccountId.equals(thatObj.effectivePayerAccountId)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "AssessedCustomFee[amount=" + this.amount + ", tokenId=" + String.valueOf(this.tokenId) + ", feeCollectorAccountId=" + String.valueOf(this.feeCollectorAccountId) + ", effectivePayerAccountId=" + String.valueOf(this.effectivePayerAccountId) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasTokenId() {
        return this.tokenId != null;
    }

    public TokenID tokenIdOrElse(@NonNull TokenID defaultValue) {
        return this.hasTokenId() ? this.tokenId : defaultValue;
    }

    @NonNull
    public TokenID tokenIdOrThrow() {
        return Objects.requireNonNull(this.tokenId, "Field tokenId is null");
    }

    public void ifTokenId(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasTokenId()) {
            ifPresent.accept(this.tokenId);
        }
    }

    public boolean hasFeeCollectorAccountId() {
        return this.feeCollectorAccountId != null;
    }

    public AccountID feeCollectorAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasFeeCollectorAccountId() ? this.feeCollectorAccountId : defaultValue;
    }

    @NonNull
    public AccountID feeCollectorAccountIdOrThrow() {
        return Objects.requireNonNull(this.feeCollectorAccountId, "Field feeCollectorAccountId is null");
    }

    public void ifFeeCollectorAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasFeeCollectorAccountId()) {
            ifPresent.accept(this.feeCollectorAccountId);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.amount, this.tokenId, this.feeCollectorAccountId, this.effectivePayerAccountId, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private long amount = 0L;
        @Nullable
        private TokenID tokenId = null;
        @Nullable
        private AccountID feeCollectorAccountId = null;
        @NonNull
        private List<AccountID> effectivePayerAccountId = Collections.emptyList();
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(long amount, TokenID tokenId, AccountID feeCollectorAccountId, List<AccountID> effectivePayerAccountId) {
            this.$unknownFields = null;
            this.amount = amount;
            this.tokenId = tokenId;
            this.feeCollectorAccountId = feeCollectorAccountId;
            this.effectivePayerAccountId = effectivePayerAccountId == null ? Collections.emptyList() : effectivePayerAccountId;
        }

        public Builder(long amount, TokenID tokenId, AccountID feeCollectorAccountId, List<AccountID> effectivePayerAccountId, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.amount = amount;
            this.tokenId = tokenId;
            this.feeCollectorAccountId = feeCollectorAccountId;
            this.effectivePayerAccountId = effectivePayerAccountId == null ? Collections.emptyList() : effectivePayerAccountId;
        }

        public AssessedCustomFee build() {
            return new AssessedCustomFee(this.amount, this.tokenId, this.feeCollectorAccountId, this.effectivePayerAccountId);
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public Builder tokenId(@Nullable TokenID tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Builder tokenId(TokenID.Builder builder) {
            this.tokenId = builder.build();
            return this;
        }

        public Builder feeCollectorAccountId(@Nullable AccountID feeCollectorAccountId) {
            this.feeCollectorAccountId = feeCollectorAccountId;
            return this;
        }

        public Builder feeCollectorAccountId(AccountID.Builder builder) {
            this.feeCollectorAccountId = builder.build();
            return this;
        }

        public Builder effectivePayerAccountId(@NonNull List<AccountID> effectivePayerAccountId) {
            this.effectivePayerAccountId = effectivePayerAccountId != null ? effectivePayerAccountId : Collections.emptyList();
            return this;
        }

        public Builder effectivePayerAccountId(AccountID ... values) {
            this.effectivePayerAccountId = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public long amount() {
            return this.amount;
        }

        public TokenID tokenId() {
            return this.tokenId;
        }

        public AccountID feeCollectorAccountId() {
            return this.feeCollectorAccountId;
        }

        public List<AccountID> effectivePayerAccountId() {
            return this.effectivePayerAccountId;
        }
    }
}

