/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.communication.multithreaded;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.test.fixtures.platform.TestPlatformContextBuilder;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.extensions.test.fixtures.TestConfigBuilder;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.network.ConnectionManager;
import com.swirlds.platform.network.communication.NegotiationProtocols;
import com.swirlds.platform.network.communication.ProtocolNegotiatorThread;
import com.swirlds.platform.test.fixtures.communication.TestPeerProtocol;
import com.swirlds.platform.test.fixtures.communication.multithreaded.ReturnOnceConnectionManager;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

class TestNegotiator {
    private final Configuration configuration = new TestConfigBuilder().getOrCreateConfig();
    private final PlatformContext platformContext = TestPlatformContextBuilder.create().withConfiguration(this.configuration).build();
    private final TestPeerProtocol protocol;
    private final ProtocolNegotiatorThread negotiator;
    private final Thread thread;
    private final AtomicInteger handshakeRan = new AtomicInteger(0);
    private volatile Exception thrown;

    public TestNegotiator(Connection connection, TestPeerProtocol protocol) {
        ReturnOnceConnectionManager connectionManager = new ReturnOnceConnectionManager(connection);
        this.protocol = protocol.setRunProtocol(Connection::disconnect);
        this.negotiator = new ProtocolNegotiatorThread((ConnectionManager)connectionManager, 100, List.of(c -> this.handshakeRan.incrementAndGet()), new NegotiationProtocols(List.of(protocol)), this.platformContext.getTime());
        this.thread = new Thread(this::run);
    }

    private void run() {
        try {
            this.negotiator.run();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            this.thrown = e;
        }
    }

    public TestPeerProtocol getProtocol() {
        return this.protocol;
    }

    public Thread getThread() {
        return this.thread;
    }

    public int getHandshakeRunNumber() {
        return this.handshakeRan.get();
    }

    public void rethrow() throws Exception {
        if (this.thrown != null) {
            throw this.thrown;
        }
    }
}

