/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.sync;

import com.swirlds.platform.gossip.shadowgraph.ShadowEvent;
import com.swirlds.platform.internal.LinkedEvent;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Stream;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.test.fixtures.event.TestingEventBuilder;

public class EventFactory {
    public static ShadowEvent makeShadow(@NonNull Random random) {
        return EventFactory.makeShadow(random, null);
    }

    public static ShadowEvent makeShadow(@NonNull Random random, ShadowEvent selfParent) {
        return EventFactory.makeShadow(random, selfParent, null);
    }

    public static ShadowEvent makeShadow(@NonNull Random random, ShadowEvent selfParent, ShadowEvent otherParent) {
        long maxParentsBirthRound = Stream.of(selfParent, otherParent).filter(Objects::nonNull).map(LinkedEvent::getPlatformEvent).mapToLong(PlatformEvent::getBirthRound).max().orElse(0L);
        TestingEventBuilder eventBuilder = new TestingEventBuilder(random);
        PlatformEvent platformEvent = eventBuilder.setSelfParent(selfParent == null ? null : selfParent.getPlatformEvent()).setOtherParent(otherParent == null ? null : otherParent.getPlatformEvent()).setBirthRound(maxParentsBirthRound + 1L).build();
        return new ShadowEvent(platformEvent, Stream.of(selfParent, otherParent).filter(Objects::nonNull).toList());
    }
}

