/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.test.fixtures;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.metrics.PlatformMetricsFactory;
import com.swirlds.common.metrics.config.MetricsConfig;
import com.swirlds.common.metrics.platform.DefaultPlatformMetrics;
import com.swirlds.common.metrics.platform.MetricKeyRegistry;
import com.swirlds.common.metrics.platform.PlatformMetricsFactoryImpl;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.extensions.test.fixtures.TestConfigBuilder;
import com.swirlds.merkledb.MerkleDbDataSource;
import com.swirlds.merkledb.MerkleDbStatistics;
import com.swirlds.merkledb.config.MerkleDbConfig;
import com.swirlds.merkledb.test.fixtures.ExampleByteArrayVirtualValue;
import com.swirlds.merkledb.test.fixtures.ExampleFixedValue;
import com.swirlds.merkledb.test.fixtures.ExampleLongKey;
import com.swirlds.merkledb.test.fixtures.ExampleLongLongKey;
import com.swirlds.merkledb.test.fixtures.ExampleVariableKey;
import com.swirlds.merkledb.test.fixtures.ExampleVariableValue;
import com.swirlds.merkledb.test.fixtures.MerkleDbTestUtils;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.virtualmap.datasource.VirtualHashRecord;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ScheduledExecutorService;
import org.hiero.consensus.model.node.NodeId;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public enum TestType {
    long_fixed(true),
    long_variable(false),
    longLong_fixed(true),
    longLong_variable(false),
    variable_fixed(false),
    variable_variable(false);

    public final boolean fixedSize;
    private Metrics metrics = null;

    private TestType(boolean fixedSize) {
        this.fixedSize = fixedSize;
    }

    public DataTypeConfig dataType() {
        return new DataTypeConfig(this);
    }

    public Metrics getMetrics() {
        if (this.metrics == null) {
            Configuration CONFIGURATION = new TestConfigBuilder().getOrCreateConfig();
            MetricsConfig metricsConfig = (MetricsConfig)CONFIGURATION.getConfigData(MetricsConfig.class);
            MetricKeyRegistry registry = (MetricKeyRegistry)Mockito.mock(MetricKeyRegistry.class);
            Mockito.when((Object)registry.register((NodeId)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Class)ArgumentMatchers.any())).thenReturn((Object)true);
            this.metrics = new DefaultPlatformMetrics(null, registry, (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class), (PlatformMetricsFactory)new PlatformMetricsFactoryImpl(metricsConfig), metricsConfig);
            MerkleDbStatistics statistics = new MerkleDbStatistics((MerkleDbConfig)CONFIGURATION.getConfigData(MerkleDbConfig.class), "test");
            statistics.registerMetrics(this.metrics);
        }
        return this.metrics;
    }

    public class DataTypeConfig {
        private final TestType testType;

        public DataTypeConfig(TestType testType) {
            this.testType = testType;
        }

        public Bytes createVirtualLongKey(int i) {
            switch (this.testType.ordinal()) {
                default: {
                    return ExampleLongKey.longToKey(i);
                }
                case 2: 
                case 3: {
                    return ExampleLongLongKey.longToKey(i);
                }
                case 4: 
                case 5: 
            }
            return ExampleVariableKey.longToKey(i);
        }

        public ExampleByteArrayVirtualValue createVirtualValue(int i) {
            switch (this.testType.ordinal()) {
                default: {
                    return new ExampleFixedValue(i);
                }
                case 1: 
                case 3: 
                case 5: 
            }
            return new ExampleVariableValue(i);
        }

        public Codec<? extends ExampleByteArrayVirtualValue> getCodec() {
            return switch (this.testType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> ExampleFixedValue.CODEC;
                case 2 -> ExampleFixedValue.CODEC;
                case 4 -> ExampleFixedValue.CODEC;
                case 1 -> ExampleVariableValue.CODEC;
                case 3 -> ExampleVariableValue.CODEC;
                case 5 -> ExampleVariableValue.CODEC;
            };
        }

        public long getDataFileLowLevelTestFileSize() {
            switch (this.testType.ordinal()) {
                default: 
            }
            return 24576L;
        }

        public MerkleDbDataSource createDataSource(Path dbPath, String name, int size, long hashesRamToDiskThreshold, boolean enableMerging, boolean preferDiskBasedIndexes) throws IOException {
            MerkleDbDataSource dataSource = new MerkleDbDataSource(dbPath, MerkleDbTestUtils.CONFIGURATION, name, (long)size, hashesRamToDiskThreshold, enableMerging, preferDiskBasedIndexes);
            dataSource.registerMetrics(TestType.this.getMetrics());
            return dataSource;
        }

        public MerkleDbDataSource getDataSource(Path dbPath, String name, boolean enableMerging) throws IOException {
            return new MerkleDbDataSource(dbPath, MerkleDbTestUtils.CONFIGURATION, name, enableMerging, false);
        }

        public VirtualHashRecord createVirtualInternalRecord(int i) {
            return new VirtualHashRecord((long)i, MerkleDbTestUtils.hash(i));
        }

        public VirtualLeafBytes createVirtualLeafRecord(int i) {
            return this.createVirtualLeafRecord(i, i, i);
        }

        public VirtualLeafBytes createVirtualLeafRecord(long path, int i, int valueIndex) {
            switch (this.testType.ordinal()) {
                default: {
                    return new VirtualLeafBytes(path, this.createVirtualLongKey(i), (Object)new ExampleFixedValue(valueIndex), (Codec)ExampleFixedValue.CODEC);
                }
                case 1: 
                case 3: 
                case 5: 
            }
            return new VirtualLeafBytes(path, this.createVirtualLongKey(i), (Object)new ExampleVariableValue(valueIndex), (Codec)ExampleVariableValue.CODEC);
        }
    }
}

