/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.system.status.logic;

import com.swirlds.platform.system.status.IllegalPlatformStatusException;
import com.swirlds.platform.system.status.PlatformStatusConfig;
import com.swirlds.platform.system.status.actions.CatastrophicFailureAction;
import com.swirlds.platform.system.status.actions.DoneReplayingEventsAction;
import com.swirlds.platform.system.status.actions.FallenBehindAction;
import com.swirlds.platform.system.status.actions.FreezePeriodEnteredAction;
import com.swirlds.platform.system.status.actions.ReconnectCompleteAction;
import com.swirlds.platform.system.status.actions.SelfEventReachedConsensusAction;
import com.swirlds.platform.system.status.actions.StartedReplayingEventsAction;
import com.swirlds.platform.system.status.actions.StateWrittenToDiskAction;
import com.swirlds.platform.system.status.actions.TimeElapsedAction;
import com.swirlds.platform.system.status.logic.CatastrophicFailureStatusLogic;
import com.swirlds.platform.system.status.logic.PlatformStatusLogic;
import com.swirlds.platform.system.status.logic.ReplayingEventsStatusLogic;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hiero.consensus.model.status.PlatformStatus;

public class StartingUpStatusLogic
implements PlatformStatusLogic {
    private final PlatformStatusConfig config;

    public StartingUpStatusLogic(@NonNull PlatformStatusConfig config) {
        this.config = Objects.requireNonNull(config);
    }

    @Override
    @NonNull
    public PlatformStatusLogic processCatastrophicFailureAction(@NonNull CatastrophicFailureAction action) {
        return new CatastrophicFailureStatusLogic();
    }

    @Override
    @NonNull
    public PlatformStatusLogic processDoneReplayingEventsAction(@NonNull DoneReplayingEventsAction action) {
        Objects.requireNonNull(action);
        throw new IllegalPlatformStatusException(action, this.getStatus());
    }

    @Override
    @NonNull
    public PlatformStatusLogic processFallenBehindAction(@NonNull FallenBehindAction action) {
        Objects.requireNonNull(action);
        throw new IllegalPlatformStatusException(action, this.getStatus());
    }

    @Override
    @NonNull
    public PlatformStatusLogic processFreezePeriodEnteredAction(@NonNull FreezePeriodEnteredAction action) {
        Objects.requireNonNull(action);
        throw new IllegalPlatformStatusException(action, this.getStatus());
    }

    @Override
    @NonNull
    public PlatformStatusLogic processReconnectCompleteAction(@NonNull ReconnectCompleteAction action) {
        Objects.requireNonNull(action);
        throw new IllegalPlatformStatusException(action, this.getStatus());
    }

    @Override
    @NonNull
    public PlatformStatusLogic processSelfEventReachedConsensusAction(@NonNull SelfEventReachedConsensusAction action) {
        Objects.requireNonNull(action);
        throw new IllegalPlatformStatusException(action, this.getStatus());
    }

    @Override
    @NonNull
    public PlatformStatusLogic processStartedReplayingEventsAction(@NonNull StartedReplayingEventsAction action) {
        return new ReplayingEventsStatusLogic(this.config);
    }

    @Override
    @NonNull
    public PlatformStatusLogic processStateWrittenToDiskAction(@NonNull StateWrittenToDiskAction action) {
        Objects.requireNonNull(action);
        throw new IllegalPlatformStatusException(action, this.getStatus());
    }

    @Override
    @NonNull
    public PlatformStatusLogic processTimeElapsedAction(@NonNull TimeElapsedAction action) {
        return this;
    }

    @Override
    @NonNull
    public PlatformStatus getStatus() {
        return PlatformStatus.STARTING_UP;
    }
}

