/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl.tipset;

import edu.umd.cs.findbugs.annotations.NonNull;

public record TipsetAdvancementWeight(long advancementWeight, long zeroWeightAdvancementCount) {
    public static final TipsetAdvancementWeight ZERO_ADVANCEMENT_WEIGHT = TipsetAdvancementWeight.of(0L, 0L);

    public static TipsetAdvancementWeight of(long advancementWeight, long zeroWeightAdvancementCount) {
        return new TipsetAdvancementWeight(advancementWeight, zeroWeightAdvancementCount);
    }

    @NonNull
    public TipsetAdvancementWeight minus(@NonNull TipsetAdvancementWeight that) {
        return new TipsetAdvancementWeight(this.advancementWeight - that.advancementWeight, this.zeroWeightAdvancementCount - that.zeroWeightAdvancementCount);
    }

    @NonNull
    public TipsetAdvancementWeight plus(@NonNull TipsetAdvancementWeight that) {
        return new TipsetAdvancementWeight(this.advancementWeight + that.advancementWeight, this.zeroWeightAdvancementCount + that.zeroWeightAdvancementCount);
    }

    public boolean isGreaterThan(@NonNull TipsetAdvancementWeight that) {
        return this.advancementWeight > that.advancementWeight || this.advancementWeight == that.advancementWeight && this.zeroWeightAdvancementCount > that.zeroWeightAdvancementCount;
    }

    public boolean isNonZero() {
        return this.advancementWeight != 0L || this.zeroWeightAdvancementCount != 0L;
    }
}

