/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.factory.primitive.BooleanBags;
import org.eclipse.collections.api.factory.primitive.BooleanLists;
import org.eclipse.collections.api.iterator.BooleanIterator;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.BooleanSet;
import org.eclipse.collections.api.set.primitive.ImmutableBooleanSet;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.api.tuple.primitive.BooleanBooleanPair;
import org.eclipse.collections.impl.factory.primitive.BooleanSets;
import org.eclipse.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableBooleanEmptySet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableBooleanSetSerializationProxy;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableFalseSet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableTrueSet;

final class ImmutableTrueFalseSet
implements ImmutableBooleanSet,
Serializable {
    static final ImmutableBooleanSet INSTANCE = new ImmutableTrueFalseSet();

    private ImmutableTrueFalseSet() {
    }

    public ImmutableBooleanSet newWith(boolean element) {
        return INSTANCE;
    }

    public ImmutableBooleanSet newWithout(boolean element) {
        return element ? ImmutableFalseSet.INSTANCE : ImmutableTrueSet.INSTANCE;
    }

    public ImmutableBooleanSet newWithAll(BooleanIterable elements) {
        ImmutableTrueFalseSet result = this;
        BooleanIterator booleanIterator = elements.booleanIterator();
        while (booleanIterator.hasNext()) {
            result = result.newWith(booleanIterator.next());
        }
        return result;
    }

    public ImmutableBooleanSet newWithoutAll(BooleanIterable elements) {
        ImmutableTrueFalseSet result = this;
        BooleanIterator booleanIterator = elements.booleanIterator();
        while (booleanIterator.hasNext()) {
            result = result.newWithout(booleanIterator.next());
        }
        return result;
    }

    public BooleanIterator booleanIterator() {
        return new FalseTrueIterator();
    }

    public void forEach(BooleanProcedure procedure) {
        this.each(procedure);
    }

    public void each(BooleanProcedure procedure) {
        procedure.value(false);
        procedure.value(true);
    }

    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(function.valueOf(injectedValue, false), true);
    }

    public RichIterable<BooleanIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        if (size == 1) {
            return Lists.immutable.with((Object)BooleanSets.immutable.with(false), (Object)BooleanSets.immutable.with(true));
        }
        return Lists.immutable.with((Object)this);
    }

    public int count(BooleanPredicate predicate) {
        int count = 0;
        if (predicate.accept(false)) {
            ++count;
        }
        if (predicate.accept(true)) {
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        return predicate.accept(false) || predicate.accept(true);
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        return predicate.accept(false) && predicate.accept(true);
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return !predicate.accept(false) && !predicate.accept(true);
    }

    public ImmutableBooleanSet select(BooleanPredicate predicate) {
        if (predicate.accept(true)) {
            return predicate.accept(false) ? this : ImmutableTrueSet.INSTANCE;
        }
        return predicate.accept(false) ? ImmutableFalseSet.INSTANCE : ImmutableBooleanEmptySet.INSTANCE;
    }

    public ImmutableBooleanSet reject(BooleanPredicate predicate) {
        if (predicate.accept(true)) {
            return predicate.accept(false) ? ImmutableBooleanEmptySet.INSTANCE : ImmutableFalseSet.INSTANCE;
        }
        return predicate.accept(false) ? ImmutableTrueSet.INSTANCE : this;
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        if (predicate.accept(false)) {
            return false;
        }
        if (predicate.accept(true)) {
            return true;
        }
        return ifNone;
    }

    public <V> ImmutableSet<V> collect(BooleanToObjectFunction<? extends V> function) {
        return Sets.immutable.with(function.valueOf(false), function.valueOf(true));
    }

    public boolean[] toArray() {
        return new boolean[]{false, true};
    }

    public boolean[] toArray(boolean[] target) {
        if (target.length < 2) {
            target = new boolean[]{false, true};
        } else {
            target[0] = false;
            target[1] = true;
        }
        return target;
    }

    public boolean contains(boolean value) {
        return true;
    }

    public boolean containsAll(boolean ... source) {
        return true;
    }

    public boolean containsAll(BooleanIterable source) {
        return true;
    }

    public BooleanSet freeze() {
        return this;
    }

    public ImmutableBooleanSet toImmutable() {
        return this;
    }

    public int size() {
        return 2;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public LazyIterable<BooleanBooleanPair> cartesianProduct(BooleanSet set) {
        return BooleanSets.cartesianProduct((BooleanSet)this, set);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BooleanSet)) {
            return false;
        }
        BooleanSet other = (BooleanSet)obj;
        return other.contains(false) && other.contains(true);
    }

    public int hashCode() {
        return 2468;
    }

    public String toString() {
        return "[false, true]";
    }

    public String makeString() {
        return "false, true";
    }

    public String makeString(String separator) {
        return "false" + separator + "true";
    }

    public String makeString(String start, String separator, String end) {
        return start + "false" + separator + "true" + end;
    }

    public void appendString(Appendable appendable) {
        try {
            appendable.append("false, true");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void appendString(Appendable appendable, String separator) {
        try {
            appendable.append("false");
            appendable.append(separator);
            appendable.append("true");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append("false");
            appendable.append(separator);
            appendable.append("true");
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MutableBooleanList toList() {
        return BooleanLists.mutable.withAll((BooleanIterable)this);
    }

    public MutableBooleanSet toSet() {
        return BooleanSets.mutable.withAll((BooleanIterable)this);
    }

    public MutableBooleanBag toBag() {
        return BooleanBags.mutable.withAll((BooleanIterable)this);
    }

    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter((BooleanIterable)this);
    }

    private Object writeReplace() {
        return new ImmutableBooleanSetSerializationProxy((BooleanSet)this);
    }

    private static final class FalseTrueIterator
    implements BooleanIterator {
        private int currentIndex;

        private FalseTrueIterator() {
        }

        public boolean next() {
            switch (this.currentIndex) {
                case 0: {
                    ++this.currentIndex;
                    return false;
                }
                case 1: {
                    ++this.currentIndex;
                    return true;
                }
            }
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return this.currentIndex < 2;
        }
    }
}

