/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.roster;

import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.utility.Pair;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class RosterDiff {
    @NonNull
    public static RosterDiffReport report(@Nullable Roster oldRoster, @Nullable Roster newRoster) {
        if (oldRoster == null && newRoster == null) {
            return new RosterDiffReport(List.of(), List.of(), List.of());
        }
        if (oldRoster == null) {
            return new RosterDiffReport(newRoster.rosterEntries(), List.of(), List.of());
        }
        if (newRoster == null) {
            return new RosterDiffReport(List.of(), oldRoster.rosterEntries(), List.of());
        }
        Map oldEntriesById = oldRoster.rosterEntries().stream().collect(Collectors.toMap(RosterEntry::nodeId, Function.identity()));
        Map newEntriesById = newRoster.rosterEntries().stream().collect(Collectors.toMap(RosterEntry::nodeId, Function.identity()));
        List<RosterEntry> deletedEntries = oldEntriesById.keySet().stream().filter(nodeId -> !newEntriesById.containsKey(nodeId)).map(oldEntriesById::get).collect(Collectors.toList());
        List<RosterEntry> addedEntries = newEntriesById.keySet().stream().filter(nodeId -> !oldEntriesById.containsKey(nodeId)).map(newEntriesById::get).collect(Collectors.toList());
        List<Pair<RosterEntry, RosterEntry>> modifiedEntries = newEntriesById.values().stream().map(newEntry -> {
            RosterEntry oldEntry = (RosterEntry)oldEntriesById.get(newEntry.nodeId());
            if (oldEntry != null && !newEntry.equals((Object)oldEntry)) {
                return Pair.of((Object)oldEntry, (Object)newEntry);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return new RosterDiffReport(addedEntries, deletedEntries, modifiedEntries);
    }

    public record RosterDiffReport(List<RosterEntry> added, List<RosterEntry> deleted, List<Pair<RosterEntry, RosterEntry>> modified) {
        public static final String PARENT_FIELD_TAB = "  - ";
        public static final String CHILD_FIELD_TAB = "    -- ";

        public RosterDiffReport {
            Objects.requireNonNull(added);
            Objects.requireNonNull(deleted);
            Objects.requireNonNull(modified);
        }

        public boolean hasChanges() {
            return !this.added.isEmpty() || !this.deleted.isEmpty() || !this.modified.isEmpty();
        }

        @NonNull
        public String print() {
            if (!this.hasChanges()) {
                return "No differences found between the rosters.";
            }
            StringBuilder report = new StringBuilder("Roster Comparison Result:\n");
            report.append("=========================\n");
            if (!this.added.isEmpty()) {
                report.append("\n--- ADDED ---\n");
                this.added.stream().map(arg_0 -> ((JsonCodec)RosterEntry.JSON).toJSON(arg_0)).forEach(entry -> report.append((String)entry).append("\n"));
            }
            if (!this.deleted.isEmpty()) {
                report.append("\n--- DELETED ---\n");
                report.append("Node IDs:").append(this.deleted.stream().map(RosterEntry::nodeId).toList()).append("\n");
            }
            if (!this.modified.isEmpty()) {
                report.append("\n--- MODIFIED ---\n");
                this.modified.forEach(mod -> {
                    RosterEntry oldE = (RosterEntry)mod.left();
                    RosterEntry newE = (RosterEntry)mod.right();
                    report.append("Node ID: ").append(newE.nodeId()).append("\n");
                    RosterDiffReport.reportDiffForWeight(oldE, newE, report);
                    RosterDiffReport.reportDiffForCaCertificate(oldE, newE, report);
                    RosterDiffReport.reportDiffForServiceEndpoint(oldE, newE, report);
                });
            }
            return report.toString();
        }

        private static void reportDiffForServiceEndpoint(RosterEntry oldE, RosterEntry newE, StringBuilder report) {
            if (!oldE.gossipEndpoint().equals(newE.gossipEndpoint())) {
                report.append(PARENT_FIELD_TAB);
                report.append("gossipEndpoint: \n");
                if (oldE.gossipEndpoint().size() != newE.gossipEndpoint().size()) {
                    report.append(String.format("%ssize: %d -> %d", CHILD_FIELD_TAB, oldE.gossipEndpoint().size(), newE.gossipEndpoint().size()));
                    if (newE.gossipEndpoint().size() > oldE.gossipEndpoint().size()) {
                        report.append(". Only first entry will be used.");
                    }
                    report.append("\n");
                }
                ServiceEndpoint oldEndpoint = (ServiceEndpoint)oldE.gossipEndpoint().getFirst();
                ServiceEndpoint newEndpoint = (ServiceEndpoint)newE.gossipEndpoint().getFirst();
                RosterDiffReport.reportDiffForIpAddress(report, oldEndpoint, newEndpoint);
                RosterDiffReport.reportDiffForPort(report, oldEndpoint, newEndpoint);
                RosterDiffReport.reportDiffForDomainName(report, oldEndpoint, newEndpoint);
            }
        }

        private static void reportDiffForCaCertificate(RosterEntry oldE, RosterEntry newE, StringBuilder report) {
            RosterDiffReport.reportDiff(oldE, newE, report, RosterEntry::gossipCaCertificate, Bytes::toBase64, PARENT_FIELD_TAB, "gossipCaCertificate");
        }

        private static void reportDiffForWeight(RosterEntry oldE, RosterEntry newE, StringBuilder report) {
            RosterDiffReport.reportDiff(oldE, newE, report, RosterEntry::weight, Object::toString, PARENT_FIELD_TAB, "weight");
        }

        private static <T, S> void reportDiff(T oldE, T newE, StringBuilder report, Function<T, S> extract, Function<S, String> toString, String tab, String name) {
            S neValue;
            S oldValue = extract.apply(oldE);
            if (!oldValue.equals(neValue = extract.apply(newE))) {
                report.append(String.format("%s%s: '%s' -> '%s'%n", tab, name, toString.apply(oldValue), toString.apply(neValue)));
            }
        }

        private static void reportDiffForDomainName(StringBuilder report, ServiceEndpoint oldEndpoint, ServiceEndpoint newEndpoint) {
            RosterDiffReport.reportDiff(oldEndpoint, newEndpoint, report, ServiceEndpoint::domainName, Object::toString, CHILD_FIELD_TAB, "domainName");
        }

        private static void reportDiffForPort(StringBuilder report, ServiceEndpoint oldEndpoint, ServiceEndpoint newEndpoint) {
            RosterDiffReport.reportDiff(oldEndpoint, newEndpoint, report, ServiceEndpoint::port, Object::toString, CHILD_FIELD_TAB, "port");
        }

        private static void reportDiffForIpAddress(StringBuilder report, ServiceEndpoint oldEndpoint, ServiceEndpoint newEndpoint) {
            RosterDiffReport.reportDiff(oldEndpoint, newEndpoint, report, ServiceEndpoint::ipAddressV4, v -> HapiUtils.asReadableIp((Bytes)v) + " (" + v.toBase64() + ")", CHILD_FIELD_TAB, "ipAddressV4");
        }
    }
}

