/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform;

import com.google.protobuf.ByteString;
import com.swirlds.common.FastCopyable;
import com.swirlds.demo.merkle.map.FCMConfig;
import com.swirlds.demo.merkle.map.FCMTransactionPool;
import com.swirlds.demo.merkle.map.internal.ExpectedFCMFamily;
import com.swirlds.demo.platform.PAYLOAD_TYPE;
import com.swirlds.demo.platform.PayloadConfig;
import com.swirlds.demo.platform.PayloadDistribution;
import com.swirlds.demo.platform.PayloadProperty;
import com.swirlds.demo.platform.TransactionPoolConfig;
import com.swirlds.demo.platform.TransactionSubmitter;
import com.swirlds.demo.platform.Triple;
import com.swirlds.demo.platform.freeze.FreezeConfig;
import com.swirlds.demo.platform.fs.stresstest.proto.AppTransactionSignatureType;
import com.swirlds.demo.platform.fs.stresstest.proto.ControlTransaction;
import com.swirlds.demo.platform.fs.stresstest.proto.ControlType;
import com.swirlds.demo.platform.fs.stresstest.proto.FreezeTransaction;
import com.swirlds.demo.platform.fs.stresstest.proto.RandomBytesTransaction;
import com.swirlds.demo.platform.fs.stresstest.proto.SimpleAction;
import com.swirlds.demo.platform.fs.stresstest.proto.TestTransaction;
import com.swirlds.demo.platform.fs.stresstest.proto.TestTransactionWrapper;
import com.swirlds.demo.platform.iss.IssConfig;
import com.swirlds.demo.virtualmerkle.config.VirtualMerkleConfig;
import com.swirlds.demo.virtualmerkle.transaction.pool.VirtualMerkleTransactionPool;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import com.swirlds.platform.Utilities;
import com.swirlds.platform.system.Platform;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.util.Supplier;
import org.hiero.base.crypto.test.fixtures.ECDSASigningProvider;
import org.hiero.base.crypto.test.fixtures.ED25519SigningProvider;
import org.hiero.base.crypto.test.fixtures.SigningProvider;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.transaction.TransactionPoolNexus;

public class PttTransactionPool
implements FastCopyable {
    private static final Logger logger = LogManager.getLogger(PttTransactionPool.class);
    private static final Marker MARKER = MarkerManager.getMarker((String)"DEMO_INFO");
    private static final Marker ERROR = MarkerManager.getMarker((String)"EXCEPTION");
    private static final int FREEZE_TIME_MINIMUM_DIFFERENCE_SECONDS = 15;
    private FCMTransactionPool fcmTransactionPool;
    private VirtualMerkleTransactionPool virtualMerkleTransactionPool;
    Platform platform;
    private final TransactionSubmitter submitter;
    private boolean transactionLogged = false;
    private final boolean signed;
    private final PayloadConfig config;
    private final TransactionPoolConfig transactionPoolConfig;
    private final Random random;
    private final IssConfig issConfig;
    private final Instant initTime;
    private Map<AppTransactionSignatureType, SigningProvider> signingProviderMap = new HashMap<AppTransactionSignatureType, SigningProvider>();
    private long nextSeq = 0L;
    private long nextFileDirSeq = 0L;
    private long[] sequentialTestCount = null;
    private int sequentialTypeIndex = 0;
    private FreezeConfig freezeConfig;
    private boolean needToSubmitFreezeTx = false;
    private boolean issTransactionSent = false;

    private PttTransactionPool(PttTransactionPool sourcePool) {
        this.virtualMerkleTransactionPool = sourcePool.virtualMerkleTransactionPool;
        this.fcmTransactionPool = sourcePool.fcmTransactionPool.copy();
        this.platform = sourcePool.platform;
        this.submitter = sourcePool.submitter;
        this.transactionLogged = sourcePool.transactionLogged;
        this.signed = sourcePool.signed;
        this.config = sourcePool.config;
        this.transactionPoolConfig = sourcePool.transactionPoolConfig;
        this.random = sourcePool.random;
        this.nextSeq = sourcePool.nextSeq;
        this.nextFileDirSeq = sourcePool.nextFileDirSeq;
        if (sourcePool.sequentialTestCount != null) {
            this.sequentialTestCount = Arrays.copyOf(sourcePool.sequentialTestCount, sourcePool.sequentialTestCount.length);
        }
        this.sequentialTypeIndex = sourcePool.sequentialTypeIndex;
        this.freezeConfig = sourcePool.freezeConfig;
        this.needToSubmitFreezeTx = sourcePool.needToSubmitFreezeTx;
        this.issConfig = sourcePool.issConfig;
        this.issTransactionSent = sourcePool.issTransactionSent;
        this.initTime = sourcePool.initTime;
        this.signingProviderMap = sourcePool.signingProviderMap;
    }

    public PttTransactionPool(Platform platform, TransactionPoolNexus transactionPool, long myID, PayloadConfig config, String myName, FCMConfig fcmConfig, VirtualMerkleConfig virtualMerkleConfig, FreezeConfig freezeConfig, TransactionPoolConfig transactionPoolConfig, TransactionSubmitter submitter, ExpectedFCMFamily expectedFCMFamily, IssConfig issConfig) {
        this.random = new Random();
        this.config = config;
        this.transactionPoolConfig = transactionPoolConfig;
        this.signed = config.isAppendSig();
        this.submitter = submitter;
        this.platform = platform;
        this.initTime = Instant.now();
        if (fcmConfig != null) {
            this.fcmTransactionPool = new FCMTransactionPool(platform, transactionPool, myID, fcmConfig, submitter, this, expectedFCMFamily, config);
        }
        if (virtualMerkleConfig != null) {
            this.virtualMerkleTransactionPool = new VirtualMerkleTransactionPool(myID, virtualMerkleConfig, expectedFCMFamily);
        }
        if (freezeConfig != null && Objects.equals(platform.getSelfId(), NodeId.of((long)0L)) && freezeConfig.getStartFreezeAfterMin() > 0) {
            this.freezeConfig = freezeConfig;
            this.needToSubmitFreezeTx = true;
        }
        this.issConfig = issConfig;
        this.signingProviderMap.put(AppTransactionSignatureType.ECDSA_SECP256K1, (SigningProvider)new ECDSASigningProvider());
        this.signingProviderMap.put(AppTransactionSignatureType.ED25519, (SigningProvider)new ED25519SigningProvider());
    }

    public PttTransactionPool(Platform platform, TransactionPoolNexus transactionPool, long myID, PayloadConfig config, String myName, FCMConfig fcmConfig, VirtualMerkleConfig virtualMerkleConfig, FreezeConfig freezeConfig, TransactionPoolConfig transactionPoolConfig, TransactionSubmitter submitter, ExpectedFCMFamily expectedFCMFamily) {
        this(platform, transactionPool, myID, config, myName, fcmConfig, virtualMerkleConfig, freezeConfig, transactionPoolConfig, submitter, expectedFCMFamily, null);
    }

    private static int getRandomNumberInRange(int min, int max) {
        if (min >= max) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        Random r = new Random();
        return r.nextInt(max - min + 1) + min;
    }

    boolean invalidSig() {
        return Math.random() < this.config.getInvalidSigRatio();
    }

    boolean isFCMTransaction() {
        return Math.random() < (double)this.config.getRatioOfFCMTransaction();
    }

    Triple<byte[], PAYLOAD_TYPE, MapKey> transaction() {
        if (this.needToSubmitFreezeTx) {
            this.needToSubmitFreezeTx = false;
            logger.info(LogMarker.FREEZE.getMarker(), "Node {} submits a Freeze Transaction", (Object)this.platform.getSelfId());
            byte[] freezeLoad = this.createFreezeTranBytes(this.freezeConfig);
            return Triple.of(freezeLoad, PAYLOAD_TYPE.TYPE_TEST_SYNC, null);
        }
        if (this.issConfig != null && !this.issTransactionSent && this.issConfig.shouldSendIssTransaction(this.initTime)) {
            this.issTransactionSent = true;
            logger.info(LogMarker.STARTUP.getMarker(), "Sending ISS transaction");
            return Triple.of(this.appendSignature(TestTransaction.newBuilder().setSimpleAction(SimpleAction.CAUSE_ISS).build().toByteArray(), false), PAYLOAD_TYPE.TYPE_TEST_SYNC, null);
        }
        byte[] payload = null;
        boolean invalidSig = false;
        Triple<byte[], PAYLOAD_TYPE, MapKey> payloadPair = null;
        PAYLOAD_TYPE generateType = PAYLOAD_TYPE.TYPE_RANDOM_BYTES;
        int bufferSize = this.config.getPayloadByteSize();
        PayloadDistribution distribution = this.config.getPayloadDistribution();
        if (distribution != null) {
            PayloadProperty property = distribution.getPayloadProperty((float)this.random.nextInt(10000) / 100.0f);
            generateType = property.getType();
            bufferSize = property.getSize();
        } else {
            generateType = this.config.getType();
        }
        if (generateType == PAYLOAD_TYPE.TYPE_RANDOM_BYTES) {
            if (this.config.isVariedSize()) {
                bufferSize = PttTransactionPool.getRandomNumberInRange(this.config.getPayloadByteSize(), this.config.getMaxByteSize());
            }
            byte[] ramdomBytesPayload = new byte[bufferSize];
            this.random.nextBytes(ramdomBytesPayload);
            if (this.config.isInsertSeq()) {
                byte[] seq = Utilities.toBytes((long)this.nextSeq);
                System.arraycopy(seq, 0, ramdomBytesPayload, 0, seq.length);
                ++this.nextSeq;
            }
            RandomBytesTransaction bytesTransaction = RandomBytesTransaction.newBuilder().setIsInserSeq(this.config.isInsertSeq()).setData(ByteString.copyFrom((byte[])ramdomBytesPayload)).build();
            TestTransaction testTransaction = TestTransaction.newBuilder().setBytesTransaction(bytesTransaction).build();
            payload = testTransaction.toByteArray();
            payloadPair = Triple.of(payload, generateType, null);
        } else if (generateType == PAYLOAD_TYPE.TYPE_FCM_TEST) {
            invalidSig = this.invalidSig();
            payloadPair = this.fcmTransactionPool.getTransaction(invalidSig);
            if (payloadPair != null) {
                payload = payloadPair.left();
            }
        } else if (generateType == PAYLOAD_TYPE.TYPE_VIRTUAL_MERKLE_TEST) {
            payloadPair = this.virtualMerkleTransactionPool.getTransaction();
            if (payloadPair != null) {
                payload = payloadPair.left();
            }
        } else if (generateType == PAYLOAD_TYPE.TYPE_FCM_VIRTUAL_MIX) {
            if (this.isFCMTransaction() && (payloadPair = this.fcmTransactionPool.getTransaction(invalidSig = this.invalidSig())) != null) {
                payload = payloadPair.left();
            }
            if (payloadPair == null) {
                payloadPair = this.virtualMerkleTransactionPool.getTransaction();
                if (payloadPair != null) {
                    payload = payloadPair.left();
                } else {
                    logger.info(MARKER, "Generated enough virtual merkle test for sequential mode");
                }
            }
        }
        if (payload != null && this.config.isAppendSig()) {
            payloadPair = Triple.of(this.appendSignature(payload, invalidSig), payloadPair.middle(), payloadPair.right());
        }
        return payloadPair;
    }

    public byte[] appendSignature(byte[] payload, boolean invalidSig) {
        AppTransactionSignatureType signatureType;
        AppTransactionSignatureType appTransactionSignatureType = signatureType = this.transactionPoolConfig == null ? AppTransactionSignatureType.ED25519 : this.transactionPoolConfig.getRandomSigType();
        if (payload != null && this.config.isAppendSig()) {
            return this.signAndConcatenatePubKeySignature(payload, invalidSig, signatureType);
        }
        return payload;
    }

    public byte[] createControlTranBytes(ControlType type) {
        ControlTransaction msg = ControlTransaction.newBuilder().setType(type).build();
        TestTransaction testTransaction = TestTransaction.newBuilder().setControlTransaction(msg).build();
        byte[] data = testTransaction.toByteArray();
        return this.appendSignature(data, false);
    }

    public byte[] createFreezeTranBytes(FreezeConfig freezeConfig) {
        Instant configuedFreezeTime;
        Instant futureThreshold = Instant.now().plusSeconds(15L);
        if (futureThreshold.isAfter(configuedFreezeTime = this.initTime.plus((long)freezeConfig.getStartFreezeAfterMin(), ChronoUnit.MINUTES))) {
            configuedFreezeTime = configuedFreezeTime.plusSeconds(15L);
        }
        return this.createFreezeTranByte(configuedFreezeTime);
    }

    public byte[] createFreezeTranByte(Instant startFreezeTime) {
        FreezeTransaction msg = FreezeTransaction.newBuilder().setStartTimeEpochSecond(startFreezeTime.getEpochSecond()).build();
        TestTransaction testTransaction = TestTransaction.newBuilder().setFreezeTransaction(msg).build();
        byte[] data = testTransaction.toByteArray();
        return this.appendSignature(data, false);
    }

    public void setNextFileDirSeq(long newValue) {
        this.nextFileDirSeq = newValue;
        logger.info(LogMarker.DEMO_INFO.getMarker(), "Set nextFileDirSeq {} ", (Object)this.nextFileDirSeq);
    }

    byte[] signAndConcatenatePubKeySignature(byte[] data, boolean invalid, AppTransactionSignatureType signatureType) {
        try {
            SigningProvider signingProvider = this.signingProviderMap.get((Object)signatureType);
            byte[] sig = signingProvider.sign(data);
            if (invalid) {
                byte modified;
                byte firstByte = sig[0];
                sig[0] = modified = (byte)(~firstByte);
            }
            if (!this.transactionLogged) {
                logger.trace(LogMarker.STARTUP.getMarker(), "Signed Message { signatureType = '{}', publicKey = '{}', privateKey ='{}', signature = '{}',message = '{}' }", new Supplier[]{() -> signatureType, () -> this.hex(signingProvider.getPublicKeyBytes()), () -> this.hex(signingProvider.getPublicKeyBytes()), () -> this.hex(sig), () -> this.hex(data)});
                this.transactionLogged = true;
            }
            TestTransactionWrapper testTransactionWrapper = TestTransactionWrapper.newBuilder().setTestTransactionRawBytes(ByteString.copyFrom((byte[])data)).setSignaturesRawBytes(ByteString.copyFrom((byte[])sig)).setPublicKeyRawBytes(ByteString.copyFrom((byte[])signingProvider.getPublicKeyBytes())).setSignatureType(signatureType).build();
            return testTransactionWrapper.toByteArray();
        }
        catch (Exception ex) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to sign transaction", (Throwable)ex);
            return null;
        }
    }

    private String hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        sb.append("0x");
        for (byte b : bytes) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    public PttTransactionPool copy() {
        this.throwIfImmutable();
        return new PttTransactionPool(this);
    }

    public boolean isImmutable() {
        return false;
    }
}

