/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import com.swirlds.virtualmap.internal.reconnect.LearnerPullVirtualTreeView;
import com.swirlds.virtualmap.internal.reconnect.TeacherPullVirtualTreeView;
import java.io.IOException;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class PullVirtualTreeResponse
implements SelfSerializable {
    private static final long CLASS_ID = -1370238561956973341L;
    private final TeacherPullVirtualTreeView teacherView;
    private final LearnerPullVirtualTreeView learnerView;
    private long path;
    private Hash learnerHash;
    private Hash teacherHash;

    public PullVirtualTreeResponse() {
        this.teacherView = null;
        this.learnerView = null;
    }

    public PullVirtualTreeResponse(TeacherPullVirtualTreeView teacherView, long path, Hash learnerHash, Hash teacherHash) {
        this.teacherView = teacherView;
        this.learnerView = null;
        this.path = path;
        this.learnerHash = learnerHash;
        assert (learnerHash != null);
        this.teacherHash = teacherHash;
    }

    public PullVirtualTreeResponse(LearnerPullVirtualTreeView learnerTreeView) {
        this.teacherView = null;
        this.learnerView = learnerTreeView;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        assert (this.teacherView != null);
        out.writeLong(this.path);
        boolean isClean = this.teacherHash == null || this.teacherHash.equals((Object)this.learnerHash);
        out.write(isClean ? 0 : 1);
        this.teacherView.writeNode(out, this.path, isClean);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        assert (this.learnerView != null);
        this.path = in.readLong();
        boolean isClean = in.read() == 0;
        this.learnerView.readNode(in, this.path, isClean);
        if (this.learnerView.isLeaf(this.path)) {
            this.learnerView.getMapStats().incrementLeafHashes(1, isClean ? 1 : 0);
        } else {
            this.learnerView.getMapStats().incrementInternalHashes(1, isClean ? 1 : 0);
        }
    }

    public long getPath() {
        return this.path;
    }

    public long getClassId() {
        return -1370238561956973341L;
    }

    public int getVersion() {
        return 1;
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

