/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.schedulers.internal;

import com.swirlds.common.metrics.extensions.FractionalTimer;
import com.swirlds.component.framework.counters.ObjectCounter;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import org.hiero.base.concurrent.AbstractTask;

class SequentialTask
extends AbstractTask {
    private Consumer<Object> handler;
    private Object data;
    private SequentialTask nextTask;
    private final ObjectCounter offRamp;
    private final FractionalTimer busyTimer;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    SequentialTask(@NonNull ForkJoinPool pool, @NonNull ObjectCounter offRamp, @NonNull FractionalTimer busyTimer, @NonNull Thread.UncaughtExceptionHandler uncaughtExceptionHandler, boolean firstTask) {
        super(pool, firstTask ? 1 : 2);
        this.offRamp = offRamp;
        this.busyTimer = busyTimer;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    void send(@NonNull SequentialTask nextTask, @NonNull Consumer<Object> handler, @Nullable Object data) {
        this.nextTask = nextTask;
        this.handler = handler;
        this.data = data;
        this.send();
    }

    public boolean onExecute() {
        this.busyTimer.activate();
        try {
            this.handler.accept(this.data);
            boolean bl = true;
            return bl;
        }
        finally {
            this.offRamp.offRamp();
            this.busyTimer.deactivate();
            this.nextTask.send();
        }
    }

    protected void onException(Throwable t) {
        this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), t);
    }
}

