/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;

public final class FileManipulation {
    private FileManipulation() {
    }

    public static void truncateFile(Path file, int resultingSize) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file.toFile()));
        byte[] bytes = in.readAllBytes();
        ((InputStream)in).close();
        if (bytes.length < resultingSize) {
            throw new IllegalArgumentException("Cannot truncate a file to a size larger than its current size");
        }
        Files.delete(file);
        FileManipulation.writeSomeOfTheseBytes(file, bytes, resultingSize);
    }

    public static void truncateNBytesFromFile(Path file, int bytesToRemove) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file.toFile()));
        byte[] bytes = in.readAllBytes();
        ((InputStream)in).close();
        Files.delete(file);
        int resultingSize = Math.max(0, bytes.length - bytesToRemove);
        FileManipulation.writeSomeOfTheseBytes(file, bytes, resultingSize);
    }

    private static void writeSomeOfTheseBytes(Path file, byte[] bytes, int numberOfBytesToWrite) throws IOException {
        byte[] truncatedBytes = new byte[numberOfBytesToWrite];
        System.arraycopy(bytes, 0, truncatedBytes, 0, truncatedBytes.length);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file.toFile()));
        ((OutputStream)out).write(truncatedBytes);
        ((OutputStream)out).close();
    }

    public static void writeRandomBytes(Random random, Path path, int size) throws IOException {
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        byte[] bytes = new byte[size];
        random.nextBytes(bytes);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(path.toFile()));
        ((OutputStream)out).write(bytes);
        ((OutputStream)out).close();
    }

    public static void corruptFile(Random random, Path file, int corruptionStartIndex) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file.toFile()));
        byte[] bytes = in.readAllBytes();
        ((InputStream)in).close();
        if (bytes.length < corruptionStartIndex) {
            throw new IllegalArgumentException("Requested corruption index exceeds size of file");
        }
        Files.delete(file);
        byte[] corruptedBytes = new byte[bytes.length - corruptionStartIndex];
        random.nextBytes(corruptedBytes);
        System.arraycopy(corruptedBytes, 0, bytes, corruptionStartIndex, corruptedBytes.length);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file.toFile()));
        ((OutputStream)out).write(bytes);
        ((OutputStream)out).close();
    }
}

