/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime;

import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.MalformedProtobufException;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.PbjMap;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UncheckedParseException;
import com.hedera.pbj.runtime.UnmodifiableArrayList;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class ProtoParserTools {
    public static final int TAG_FIELD_OFFSET = 3;

    private ProtoParserTools() {
    }

    public static <T> List<T> addToList(List<T> list, T newItem) {
        if (list == Collections.EMPTY_LIST) {
            list = new UnmodifiableArrayList<T>();
        }
        list.add(newItem);
        return list;
    }

    public static <K, V> Map<K, V> addToMap(Map<K, V> map, K key, V value) {
        if (map == PbjMap.EMPTY) {
            map = new HashMap();
        }
        map.put(key, value);
        return map;
    }

    public static int readInt32(ReadableSequentialData input) {
        return input.readVarInt(false);
    }

    public static long readInt64(ReadableSequentialData input) {
        return input.readVarLong(false);
    }

    public static int readUint32(ReadableSequentialData input) {
        return input.readVarInt(false);
    }

    public static long readUint64(ReadableSequentialData input) {
        return input.readVarLong(false);
    }

    public static boolean readBool(ReadableSequentialData input) throws IOException {
        int i = input.readVarInt(false);
        if (i != 1 && i != 0) {
            throw new IOException("Bad protobuf encoding. Boolean was not 0 or 1");
        }
        return i == 1;
    }

    public static int readEnum(ReadableSequentialData input) {
        return input.readVarInt(false);
    }

    public static int readSignedInt32(ReadableSequentialData input) {
        return input.readVarInt(true);
    }

    public static long readSignedInt64(ReadableSequentialData input) {
        return input.readVarLong(true);
    }

    public static int readSignedFixed32(ReadableSequentialData input) {
        return input.readInt(ByteOrder.LITTLE_ENDIAN);
    }

    public static int readFixed32(ReadableSequentialData input) {
        return input.readInt(ByteOrder.LITTLE_ENDIAN);
    }

    public static float readFloat(ReadableSequentialData input) {
        return input.readFloat(ByteOrder.LITTLE_ENDIAN);
    }

    public static long readSignedFixed64(ReadableSequentialData input) {
        return input.readLong(ByteOrder.LITTLE_ENDIAN);
    }

    public static long readFixed64(ReadableSequentialData input) {
        return input.readLong(ByteOrder.LITTLE_ENDIAN);
    }

    public static double readDouble(ReadableSequentialData input) {
        return input.readDouble(ByteOrder.LITTLE_ENDIAN);
    }

    public static String readString(ReadableSequentialData input) throws IOException {
        try {
            return ProtoParserTools.readString(input, Long.MAX_VALUE);
        }
        catch (ParseException ex) {
            throw new UncheckedParseException(ex);
        }
    }

    public static String readString(ReadableSequentialData input, long maxSize) throws IOException, ParseException {
        int length = input.readVarInt(false);
        if ((long)length > maxSize) {
            throw new ParseException("size " + length + " is greater than max " + maxSize);
        }
        if (input.remaining() < (long)length) {
            throw new BufferUnderflowException();
        }
        ByteBuffer bb = ByteBuffer.allocate(length);
        long bytesRead = input.readBytes(bb);
        if (bytesRead != (long)length) {
            throw new BufferUnderflowException();
        }
        bb.rewind();
        try {
            return StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT).decode(bb).toString();
        }
        catch (CharacterCodingException e) {
            throw new MalformedProtobufException("Malformed UTF-8 string encountered", e);
        }
    }

    public static Bytes readBytes(ReadableSequentialData input) {
        try {
            return ProtoParserTools.readBytes(input, Long.MAX_VALUE);
        }
        catch (ParseException ex) {
            throw new UncheckedParseException(ex);
        }
    }

    public static Bytes readBytes(ReadableSequentialData input, long maxSize) throws ParseException {
        int length = input.readVarInt(false);
        if ((long)length > maxSize) {
            throw new ParseException("size " + length + " is greater than max " + maxSize);
        }
        if (input.remaining() < (long)length) {
            throw new BufferUnderflowException();
        }
        Bytes bytes = input.readBytes(length);
        if (bytes.length() != (long)length) {
            throw new BufferUnderflowException();
        }
        return bytes;
    }

    @Nullable
    public static Bytes extractFieldBytes(@NonNull ReadableSequentialData input, @NonNull FieldDefinition field) throws IOException, ParseException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(field);
        if (field.repeated()) {
            throw new IllegalArgumentException("Cannot extract field bytes for a repeated field: " + String.valueOf(field));
        }
        if (ProtoWriterTools.wireType(field) != ProtoConstants.WIRE_TYPE_DELIMITED) {
            throw new IllegalArgumentException("Cannot extract field bytes for a non-length-delimited field: " + String.valueOf(field));
        }
        while (input.hasRemaining()) {
            int tag;
            try {
                tag = input.readVarInt(false);
            }
            catch (BufferUnderflowException e) {
                break;
            }
            int fieldNum = tag >> 3;
            ProtoConstants wireType = ProtoConstants.get(tag & 7);
            if (fieldNum == field.number()) {
                if (wireType != ProtoConstants.WIRE_TYPE_DELIMITED) {
                    throw new ParseException("Unexpected wire type: " + tag);
                }
                int length = input.readVarInt(false);
                return input.readBytes(length);
            }
            ProtoParserTools.skipField(input, wireType);
        }
        return null;
    }

    public static Bytes extractField(ReadableSequentialData input, ProtoConstants wireType, long maxSize) throws IOException, ParseException {
        return switch (wireType) {
            case ProtoConstants.WIRE_TYPE_FIXED_64_BIT -> input.readBytes(8);
            case ProtoConstants.WIRE_TYPE_FIXED_32_BIT -> input.readBytes(4);
            case ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG -> input.readVarLongBytes();
            case ProtoConstants.WIRE_TYPE_DELIMITED -> {
                Bytes lenBytes = input.readVarLongBytes();
                int length = lenBytes.getVarInt(0L, false);
                if (length < 0) {
                    throw new IOException("Encountered a field with negative length " + length);
                }
                if ((long)length > maxSize) {
                    throw new ParseException("size " + length + " is greater than max " + maxSize);
                }
                yield Bytes.merge(lenBytes, input.readBytes(length));
            }
            case ProtoConstants.WIRE_TYPE_GROUP_START -> throw new IOException("Wire type 'Group Start' is unsupported");
            case ProtoConstants.WIRE_TYPE_GROUP_END -> throw new IOException("Wire type 'Group End' is unsupported");
            default -> throw new IOException("Unhandled wire type while trying to skip a field " + String.valueOf((Object)wireType));
        };
    }

    public static void skipField(ReadableSequentialData input, ProtoConstants wireType) throws IOException {
        try {
            ProtoParserTools.skipField(input, wireType, Long.MAX_VALUE);
        }
        catch (ParseException ex) {
            throw new UncheckedParseException(ex);
        }
    }

    public static void skipField(ReadableSequentialData input, ProtoConstants wireType, long maxSize) throws IOException, ParseException {
        switch (wireType) {
            case WIRE_TYPE_FIXED_64_BIT: {
                input.skip(8L);
                break;
            }
            case WIRE_TYPE_FIXED_32_BIT: {
                input.skip(4L);
                break;
            }
            case WIRE_TYPE_VARINT_OR_ZIGZAG: {
                input.readVarLong(false);
                break;
            }
            case WIRE_TYPE_DELIMITED: {
                int length = input.readVarInt(false);
                if (length < 0) {
                    throw new IOException("Encountered a field with negative length " + length);
                }
                if ((long)length > maxSize) {
                    throw new ParseException("size " + length + " is greater than max " + maxSize);
                }
                input.skip(length);
                break;
            }
            case WIRE_TYPE_GROUP_START: {
                throw new IOException("Wire type 'Group Start' is unsupported");
            }
            case WIRE_TYPE_GROUP_END: {
                throw new IOException("Wire type 'Group End' is unsupported");
            }
            default: {
                throw new IOException("Unhandled wire type while trying to skip a field " + String.valueOf((Object)wireType));
            }
        }
    }

    public static int readNextFieldNumber(ReadableSequentialData input) {
        int tag = input.readVarInt(false);
        return tag >> 3;
    }
}

