/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.synchronization.task;

import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.synchronization.views.TeacherPushMerkleTreeView;
import com.swirlds.common.merkle.synchronization.views.TeacherTreeView;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;

public final class TeacherSubtree
implements AutoCloseable {
    private final MerkleNode root;
    private final TeacherTreeView<?> view;

    public TeacherSubtree(@NonNull Configuration configuration, MerkleNode root) {
        this(root, new TeacherPushMerkleTreeView(configuration, root));
    }

    public TeacherSubtree(MerkleNode root, TeacherTreeView<?> view) {
        this.root = root;
        this.view = view;
        if (root != null) {
            root.reserve();
        }
    }

    public MerkleNode getRoot() {
        return this.root;
    }

    public TeacherTreeView<?> getView() {
        return this.view;
    }

    @Override
    public void close() {
        this.view.close();
        if (this.root != null) {
            this.root.release();
        }
    }
}

