/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl.tipset;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;

public class ChildlessEventTracker {
    private final Map<EventDescriptorWrapper, PlatformEvent> childlessEvents = new HashMap<EventDescriptorWrapper, PlatformEvent>();
    private final Map<NodeId, PlatformEvent> eventsByCreator = new HashMap<NodeId, PlatformEvent>();

    public void addEvent(@NonNull PlatformEvent event) {
        Objects.requireNonNull(event);
        PlatformEvent existingEvent = this.eventsByCreator.get(event.getCreatorId());
        if (existingEvent != null) {
            if (existingEvent.getNGen() >= event.getNGen()) {
                return;
            }
            this.removeEvent(existingEvent.getDescriptor());
        }
        this.insertEvent(event);
        for (EventDescriptorWrapper parent : event.getAllParents()) {
            this.removeEvent(parent);
        }
    }

    public void registerSelfEventParents(@NonNull List<EventDescriptorWrapper> parents) {
        for (EventDescriptorWrapper parent : parents) {
            this.childlessEvents.remove(parent);
        }
    }

    public void pruneOldEvents(@NonNull EventWindow eventWindow) {
        HashSet keysToRemove = new HashSet();
        this.childlessEvents.keySet().stream().filter(arg_0 -> ((EventWindow)eventWindow).isAncient(arg_0)).forEach(keysToRemove::add);
        keysToRemove.forEach(this::removeEvent);
    }

    @NonNull
    public Collection<PlatformEvent> getChildlessEvents() {
        return Collections.unmodifiableCollection(this.childlessEvents.values());
    }

    private void insertEvent(@NonNull PlatformEvent event) {
        this.childlessEvents.put(event.getDescriptor(), event);
        this.eventsByCreator.put(event.getCreatorId(), event);
    }

    private void removeEvent(@NonNull EventDescriptorWrapper event) {
        boolean removed;
        boolean bl = removed = this.childlessEvents.remove(event) != null;
        if (removed) {
            this.eventsByCreator.remove(event.creator());
        }
    }

    public void clear() {
        this.childlessEvents.clear();
        this.eventsByCreator.clear();
    }

    @NonNull
    public String toString() {
        if (this.childlessEvents.isEmpty()) {
            return "Childless events: none\n";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Childless events:\n");
        for (EventDescriptorWrapper event : this.childlessEvents.keySet()) {
            sb.append("  - ").append(event).append("\n");
        }
        return sb.toString();
    }
}

