/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import aQute.bnd.annotation.spi.ServiceProvider;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.factory.list.primitive.ImmutableBooleanListFactory;
import org.eclipse.collections.api.list.primitive.ImmutableBooleanList;
import org.eclipse.collections.impl.factory.primitive.BooleanLists;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableBooleanArrayList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableBooleanEmptyList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableBooleanSingletonList;

@ServiceProvider(value=ImmutableBooleanListFactory.class)
public class ImmutableBooleanListFactoryImpl
implements ImmutableBooleanListFactory {
    public static final ImmutableBooleanListFactory INSTANCE = new ImmutableBooleanListFactoryImpl();

    public ImmutableBooleanList empty() {
        return ImmutableBooleanEmptyList.INSTANCE;
    }

    public ImmutableBooleanList of() {
        return this.empty();
    }

    public ImmutableBooleanList with() {
        return this.empty();
    }

    public ImmutableBooleanList of(boolean one) {
        return this.with(one);
    }

    public ImmutableBooleanList with(boolean one) {
        return new ImmutableBooleanSingletonList(one);
    }

    public ImmutableBooleanList of(boolean ... items) {
        return this.with(items);
    }

    public ImmutableBooleanList with(boolean ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableBooleanArrayList.newListWith(items);
    }

    public ImmutableBooleanList ofAll(BooleanIterable items) {
        return this.withAll(items);
    }

    public ImmutableBooleanList withAll(BooleanIterable items) {
        if (items instanceof ImmutableBooleanList) {
            return (ImmutableBooleanList)items;
        }
        if (items == null || items.size() == 0) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray()[0]);
        }
        return ImmutableBooleanArrayList.newList(items);
    }

    public ImmutableBooleanList ofAll(Iterable<Boolean> iterable) {
        return this.withAll(iterable);
    }

    public ImmutableBooleanList withAll(Iterable<Boolean> iterable) {
        return BooleanLists.mutable.withAll(iterable).toImmutable();
    }
}

