/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.utility;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RandomAccessDeque<T>
implements Iterable<T> {
    private static final int DEFAULT_CAPACITY = 1024;
    private Object[] data;
    private int size;
    private int firstIndex;
    private int nextIndex;

    public RandomAccessDeque() {
        this(1024);
    }

    public RandomAccessDeque(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("capacity must be greater than 0, requested capacity is " + capacity);
        }
        this.data = new Object[capacity];
    }

    private void expand() {
        Object[] newData = new Object[this.data.length * 2];
        int firstSegmentLength = this.data.length - this.firstIndex;
        int secondSegmentLength = this.data.length - firstSegmentLength;
        System.arraycopy(this.data, this.firstIndex, newData, 0, firstSegmentLength);
        System.arraycopy(this.data, 0, newData, firstSegmentLength, secondSegmentLength);
        this.firstIndex = 0;
        this.nextIndex = this.data.length;
        this.data = newData;
    }

    public int size() {
        return this.size;
    }

    public boolean isFull() {
        return this.data.length - this.size == 0;
    }

    public void addFirst(T element) {
        if (this.isFull()) {
            this.expand();
        }
        this.firstIndex = (this.firstIndex - 1 + this.data.length) % this.data.length;
        this.data[this.firstIndex] = element;
        ++this.size;
    }

    public void addLast(T value) {
        if (this.isFull()) {
            this.expand();
        }
        this.data[this.nextIndex] = value;
        this.nextIndex = (this.nextIndex + 1) % this.data.length;
        ++this.size;
    }

    public T removeFirst() {
        T removed = this.set(0, null);
        this.firstIndex = (this.firstIndex + 1) % this.data.length;
        --this.size;
        return removed;
    }

    public T removeLast() {
        T removed = this.set(this.size() - 1, null);
        this.nextIndex = (this.nextIndex - 1 + this.data.length) % this.data.length;
        --this.size;
        return removed;
    }

    public T get(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("negative indices not supported");
        }
        if (index >= this.size()) {
            throw new NoSuchElementException("can't get element at index " + index + " in queue of size " + this.size());
        }
        return (T)this.data[(this.firstIndex + index) % this.data.length];
    }

    public T getFirst() {
        return this.get(0);
    }

    public T getLast() {
        return this.get(this.size() - 1);
    }

    public T set(int index, T value) {
        if (index < 0) {
            throw new IllegalArgumentException("negative indices not supported");
        }
        if (index >= this.size()) {
            throw new IllegalStateException("can't put element at index " + index + " in queue of size " + this.size());
        }
        int adjustedIndex = (this.firstIndex + index) % this.data.length;
        Object prev = this.data[adjustedIndex];
        this.data[adjustedIndex] = value;
        return (T)prev;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.size == 0) {
            return Collections.emptyIterator();
        }
        return this.iterator(0);
    }

    public Iterator<T> iterator(final int startingIndex) {
        if (startingIndex >= this.size()) {
            throw new IllegalArgumentException("startingIndex is " + startingIndex + " but size is " + this.size());
        }
        if (this.size == 0) {
            return Collections.emptyIterator();
        }
        return new Iterator<T>(){
            private int offset;
            {
                this.offset = startingIndex;
            }

            @Override
            public boolean hasNext() {
                return this.offset < RandomAccessDeque.this.size();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object next = RandomAccessDeque.this.get(this.offset);
                ++this.offset;
                return next;
            }
        };
    }

    public void clear() {
        Arrays.fill(this.data, null);
        this.size = 0;
        this.firstIndex = 0;
        this.nextIndex = 0;
    }
}

